/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import org.nuxeo.ecm.core.redis.RedisAbstractExecutor;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.retry.ExponentialBackofDelay;
import org.nuxeo.ecm.core.redis.retry.Retry;
import org.nuxeo.ecm.core.redis.retry.SimpleDelay;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class RedisFailoverExecutor
extends RedisAbstractExecutor {
    protected final int timeout;
    protected final RedisExecutor executor;

    public RedisFailoverExecutor(int timeout, RedisExecutor base) {
        this.timeout = timeout;
        this.executor = base;
    }

    @Override
    public <T> T execute(RedisCallable<T> callable) throws JedisConnectionException {
        return this.executeWithRetryPolicy(callable, new ExponentialBackofDelay(1, this.timeout));
    }

    @Override
    public void subscribe(JedisPubSub subscriber, String channel) throws JedisConnectionException {
        this.executeWithRetryPolicy(jedis -> {
            jedis.subscribe(subscriber, new String[]{channel});
            return null;
        }, new SimpleDelay(2000, Integer.MAX_VALUE));
    }

    protected <T> T executeWithRetryPolicy(final RedisCallable<T> callable, Retry.Policy policy) {
        try {
            return new Retry().retry(new Retry.Block<T>(){

                @Override
                public T retry() throws Retry.ContinueException, Retry.FailException {
                    try {
                        return RedisFailoverExecutor.this.executor.execute(callable);
                    }
                    catch (JedisConnectionException cause) {
                        throw new Retry.ContinueException(cause);
                    }
                }
            }, policy);
        }
        catch (Retry.FailException cause) {
            throw new JedisConnectionException("Cannot reconnect to jedis ..", (Throwable)cause);
        }
    }

    @Override
    public Pool<Jedis> getPool() {
        return this.executor.getPool();
    }
}

