/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.runtime.server.FilterMappingDescriptor;
import org.nuxeo.runtime.server.InitParamDescriptor;

@XObject(value="filter")
@XRegistry(merge=false)
public class FilterDescriptor {
    @XNode(value="@context")
    protected String context;
    @XRegistryId
    @XNode(value="filter-name", fallback="@name")
    protected String name;
    @XNode(value="filter-class", fallback="@class")
    protected Class<?> clazz;
    @XNode(value="display-name", fallback="description")
    protected String displayName;
    protected Map<String, String> initParams = new LinkedHashMap<String, String>();
    @XNodeList(value="filter-mapping", type=ArrayList.class, componentType=FilterMappingDescriptor.class)
    protected List<FilterMappingDescriptor> filterMappings;

    @XNodeList(value="init-param", type=ArrayList.class, componentType=InitParamDescriptor.class)
    public void setInitParams(List<InitParamDescriptor> descriptors) {
        for (InitParamDescriptor d : descriptors) {
            this.initParams.put(d.getName(), d.getValue());
        }
    }

    @XNodeMap(value="init-params/param", key="@name", type=HashMap.class, componentType=String.class, trim=true, nullByDefault=true)
    public void setInitParams(Map<String, String> initParams) {
        this.initParams.putAll(initParams);
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public List<FilterMappingDescriptor> getFilterMappings() {
        return this.filterMappings;
    }
}

