/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.server;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.server.ServerConfigurator;

public class ServerComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(ServerComponent.class);
    public static final String XP_WEB_APP = "webapp";
    public static final String XP_SERVLET = "servlet";
    public static final String XP_FILTER = "filter";
    public static final String XP_LISTENER = "listener";
    public static final String PORT_SYSTEM_PROP = "nuxeo.servlet-container.port";
    protected static final String CONFIGURATOR_CLASS = "org.nuxeo.runtime.server.tomcat.TomcatServerConfigurator";
    protected ServerConfigurator configurator;

    public void activate(ComponentContext context) {
        try {
            this.configurator = (ServerConfigurator)Class.forName(CONFIGURATOR_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        int p = -1;
        String configPort = System.getProperty(PORT_SYSTEM_PROP);
        if (StringUtils.isNotBlank((CharSequence)configPort)) {
            try {
                p = Integer.parseInt(configPort);
            }
            catch (NumberFormatException e) {
                log.error("Invalid port for embedded servlet container: {}", (Object)configPort);
            }
        }
        this.configurator.initialize(p);
    }

    public void deactivate(ComponentContext context) {
        this.configurator.close();
        this.configurator = null;
    }

    public int getApplicationStartedOrder() {
        return -100;
    }

    public void start(ComponentContext context) {
        this.getRegistryContributions(XP_WEB_APP).forEach(this.configurator::addWepApp);
        this.getRegistryContributions(XP_FILTER).forEach(this.configurator::addFilter);
        this.getRegistryContributions(XP_SERVLET).forEach(this.configurator::addServlet);
        this.getRegistryContributions(XP_LISTENER).forEach(this.configurator::addLifecycleListener);
        this.configurator.start();
    }

    public void stop(ComponentContext context) {
        this.configurator.stop();
    }
}

