/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;
import org.nuxeo.runtime.stream.StreamComputationPolicy;
import org.nuxeo.runtime.stream.StreamProcessorDescriptor;

public class DefaultNuxeoComputationPolicy
implements StreamComputationPolicy {
    @Override
    public ComputationPolicy getPolicy(StreamProcessorDescriptor.PolicyDescriptor descriptor) {
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(descriptor.maxRetries.intValue()).withBackoff(descriptor.delay.toMillis(), descriptor.maxDelay.toMillis(), TimeUnit.MILLISECONDS);
        retryPolicy.retryOn(new Class[]{RuntimeException.class, TimeoutException.class, IOException.class, SQLException.class});
        ComputationPolicyBuilder builder = descriptor.createPolicyBuilder();
        builder.retryPolicy(retryPolicy);
        return builder.build();
    }
}

