/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.avro;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.nuxeo.lib.stream.codec.AvroSchemaStore;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroMapperDescriptor;
import org.nuxeo.runtime.avro.AvroSchemaDescriptor;
import org.nuxeo.runtime.avro.AvroSchemaFactoryDescriptor;
import org.nuxeo.runtime.avro.AvroService;
import org.nuxeo.runtime.avro.AvroServiceImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class AvroComponent
extends DefaultComponent {
    public static final String XP_SCHEMA = "schema";
    public static final String XP_MAPPER = "mapper";
    public static final String XP_FACTORY = "factory";
    public static final String XP_REPLACEMENT = "replacement";
    protected AvroService avroService;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.avroService.getClass())) {
            return (T)this.avroService;
        }
        return null;
    }

    public int getApplicationStartedOrder() {
        return -600;
    }

    public void start(ComponentContext context) {
        super.start(context);
        List factoryDescs = this.getRegistryContributions(XP_FACTORY);
        HashMap factories = new HashMap(factoryDescs.size());
        for (AvroSchemaFactoryDescriptor descriptor : factoryDescs) {
            try {
                Class<?> type = Class.forName(descriptor.type);
                factories.put(type, Class.forName(descriptor.klass));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        List replacementDescs = this.getRegistryContributions(XP_REPLACEMENT);
        AvroServiceImpl impl = new AvroServiceImpl(replacementDescs, factories);
        List mapperDescs = this.getRegistryContributions(XP_MAPPER);
        HashMap mappers = new HashMap(mapperDescs.size());
        for (AvroMapperDescriptor descriptor : mapperDescs) {
            try {
                Class<?> type = Class.forName(descriptor.type);
                Class<?> clazz = Class.forName(descriptor.klass);
                Constructor<?> constructor = clazz.getConstructor(AvroService.class);
                mappers.put(type, (AvroMapper)constructor.newInstance(impl));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        impl.setMappers(mappers);
        List schemaDescs = this.getRegistryContributions(XP_SCHEMA);
        AvroSchemaStore schemaStore = impl.getSchemaStore();
        for (AvroSchemaDescriptor descriptor : schemaDescs) {
            URL url = context.getRuntimeContext().getResource(descriptor.file);
            try {
                InputStream stream = url == null ? null : url.openStream();
                try {
                    if (stream == null) {
                        throw new RuntimeServiceException("Could not load stream for file " + descriptor.file);
                    }
                    schemaStore.addSchema(new Schema.Parser().parse(stream));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        this.avroService = impl;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.avroService = null;
    }
}

