/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kafka;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.runtime.kafka.KafkaConfigDescriptor;

public class KafkaChecker
implements BackingChecker {
    private static final Logger log = LogManager.getLogger(KafkaChecker.class);
    private static final String KAFKA_ENABLED_PROP = "kafka.enabled";
    private static final String CONFIG_NAME = "kafka-config.xml";

    public boolean accepts(ConfigurationGenerator cg) {
        if (!"true".equals(cg.getUserConfig().getProperty(KAFKA_ENABLED_PROP))) {
            log.debug("Checker skipped because Kafka is disabled");
            return false;
        }
        return true;
    }

    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        KafkaConfigDescriptor config = this.getConfig(cg);
        try (KafkaLogManager manager = new KafkaLogManager(config.topicPrefix, config.producerProperties.properties, config.consumerProperties.properties);){
            manager.exists(Name.ofUrn((String)"input/null"));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to reach Kafka using: " + config.producerProperties.properties, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KafkaConfigDescriptor getConfig(ConfigurationGenerator cg) throws ConfigurationException {
        File configFile = new File(cg.getConfigDir(), CONFIG_NAME);
        if (!configFile.exists()) {
            throw new ConfigurationException("Cannot find Kafka configuration: kafka-config.xml");
        }
        XMap xmap = new XMap();
        xmap.register(KafkaConfigDescriptor.class);
        try (FileInputStream inStream = new FileInputStream(configFile);){
            Object[] nodes;
            Object[] objectArray = nodes = xmap.loadAll((InputStream)inStream);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node != null) {
                    KafkaConfigDescriptor kafkaConfigDescriptor = (KafkaConfigDescriptor)node;
                    return kafkaConfigDescriptor;
                }
                ++n2;
            }
            throw new ConfigurationException("No KafkaConfigDescriptor found in " + configFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load KafkaConfigDescriptor from " + configFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

