/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kafka;

import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;
import org.nuxeo.runtime.kafka.KafkaConfigDescriptor;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.model.DefaultComponent;

public class KafkaConfigServiceImpl
extends DefaultComponent
implements KafkaConfigService {
    public static final String XP_KAFKA_CONFIG = "kafkaConfig";
    public static final int APPLICATION_STARTED_ORDER = -600;
    protected static final String DEFAULT_BOOTSTRAP_SERVERS = "DEFAULT_TEST";
    protected static final long START_STAMP = System.currentTimeMillis();

    public int getApplicationStartedOrder() {
        return -600;
    }

    @Override
    public Set<String> listConfigNames() {
        return this.getRegistryContributions(XP_KAFKA_CONFIG).stream().map(KafkaConfigDescriptor.class::cast).map(KafkaConfigDescriptor::getId).collect(Collectors.toSet());
    }

    @Override
    public Properties getProducerProperties(String configName) {
        Properties ret = this.getDescriptor((String)configName).producerProperties.properties;
        if (DEFAULT_BOOTSTRAP_SERVERS.equals(ret.get("bootstrap.servers"))) {
            ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        }
        return ret;
    }

    @Override
    public Properties getConsumerProperties(String configName) {
        Properties ret = this.getDescriptor((String)configName).consumerProperties.properties;
        if (DEFAULT_BOOTSTRAP_SERVERS.equals(ret.get("bootstrap.servers"))) {
            ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        }
        return ret;
    }

    @Override
    public String getTopicPrefix(String configName) {
        Object ret;
        KafkaConfigDescriptor config = this.getDescriptor(configName);
        Object object = ret = config.topicPrefix == null ? "" : config.topicPrefix;
        if (config.randomPrefix.booleanValue()) {
            ret = (String)ret + START_STAMP + "-";
        }
        return ret;
    }

    @Override
    public Properties getAdminProperties(String configName) {
        Properties ret = this.getDescriptor((String)configName).adminProperties.properties;
        if (DEFAULT_BOOTSTRAP_SERVERS.equals(ret.get("bootstrap.servers"))) {
            ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        }
        return ret;
    }

    protected KafkaConfigDescriptor getDescriptor(String configName) {
        return (KafkaConfigDescriptor)this.getRegistryContribution(XP_KAFKA_CONFIG, configName).orElseThrow(() -> new IllegalArgumentException("Unknown configuration name: " + configName));
    }
}

