/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.stream.RuntimeStreamFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeStreamFeature.class})
@Deploy(value={"org.nuxeo.runtime.stream:test-kafka-config-contrib.xml"})
public class TestKafkaConfigService {
    @Inject
    public KafkaConfigService service;

    @Test
    public void testService() {
        Assert.assertNotNull((Object)this.service);
        Assert.assertFalse((boolean)this.service.listConfigNames().isEmpty());
        Assert.assertTrue((String)this.service.listConfigNames().toString(), (this.service.listConfigNames().size() >= 2 ? 1 : 0) != 0);
        String config1 = "config1";
        Assert.assertNotNull((Object)this.service.getAdminProperties(config1));
        Assert.assertNotNull((Object)this.service.getConsumerProperties(config1));
        Assert.assertNotNull((Object)this.service.getProducerProperties(config1));
        Assert.assertEquals((Object)"kafka-broker-1:9092,kafka-broker-2:9092", (Object)this.service.getProducerProperties(config1).getProperty("bootstrap.servers"));
        Assert.assertNotEquals((Object)"RANDOM()", (Object)this.service.getTopicPrefix(config1));
        String config2 = "config2";
        Assert.assertNotNull((Object)this.service.getConsumerProperties(config2));
        Assert.assertNotNull((Object)this.service.getProducerProperties(config2));
        Assert.assertEquals((Object)"foo", (Object)this.service.getTopicPrefix(config2));
    }
}

