/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class FailureStreamProcessor
implements StreamProcessorTopology {
    private static final Log log = LogFactory.getLog(FailureStreamProcessor.class);

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(() -> new FailureComputation("failureComp"), Collections.singletonList("i1:inputFailure")).build();
    }

    protected static class FailureComputation
    extends AbstractComputation {
        public FailureComputation(String name) {
            super(name, 1, 0);
        }

        public void processRecord(ComputationContext context, String inputStreamName, Record record) {
            log.debug((Object)(this.metadata.name() + " got record: " + record));
            throw new RuntimeException("Simulated failure for testing purpose");
        }
    }
}

