/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.message.Message;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class LogCaptureFeature
implements RunnerFeature {
    private static final Logger log = LogManager.getLogger(LogCaptureFeature.class);
    protected Filter classFilter;
    protected Filter methodFilter;
    protected volatile Filter currentFilter;
    protected final Result myResult = new Result();
    protected final Appender logAppender = new AbstractAppender("LOG_CAPTURE_APPENDER", null, null){

        public void append(LogEvent event) {
            if (LogCaptureFeature.this.currentFilter == null) {
                LogCaptureFeature.this.myResult.noFilterFlag = true;
            } else if (LogCaptureFeature.this.currentFilter.accept(event)) {
                LogCaptureFeature.this.myResult.caughtEvents.add(event);
            }
        }
    };

    @Override
    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.classFilter = this.instantiateFilter(() -> runner.getConfig(FilterWith.class), () -> runner.getConfig(FilterOn.class));
        if (this.classFilter == null) {
            log.info("Class {} uses LogCaptureFeature without defining a filter", (Object)runner.getTargetTestClass().getName());
        }
        this.currentFilter = this.classFilter;
        this.logAppender.start();
        LoggerContext.getContext((boolean)false).getRootLogger().addAppender(this.logAppender);
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(Result.class).toInstance((Object)this.myResult);
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        this.myResult.clear();
        this.methodFilter = this.instantiateFilter(() -> runner.getConfig(method, FilterWith.class), () -> runner.getConfig(method, FilterOn.class));
        if (this.methodFilter == null) {
            log.info("Method {} uses LogCaptureFeature without defining a filter", (Object)method.getName());
        }
        this.currentFilter = this.methodFilter;
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        this.myResult.clear();
        this.methodFilter = null;
        this.currentFilter = this.classFilter;
    }

    @Override
    public void afterRun(FeaturesRunner runner) {
        this.classFilter = null;
        this.currentFilter = null;
        LoggerContext.getContext((boolean)false).getRootLogger().removeAppender(this.logAppender);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Filter instantiateFilter(Supplier<FilterWith> filterWith, Supplier<FilterOn> filterOn) throws Exception {
        FilterWith filterProvider = filterWith.get();
        if (filterProvider.value() != null) return filterProvider.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        FilterOn defaultFilterConfig = filterOn.get();
        if (!StringUtils.isNotBlank((CharSequence)defaultFilterConfig.loggerName()) && !StringUtils.isNotBlank((CharSequence)defaultFilterConfig.logLevel())) {
            if (defaultFilterConfig.loggerClass() == Object.class) return null;
        }
        if (defaultFilterConfig.loggerClass() == Object.class) return new DefaultFilter(defaultFilterConfig.loggerName(), defaultFilterConfig.logLevel());
        String loggerName = defaultFilterConfig.loggerClass().getName();
        return new DefaultFilter(loggerName, defaultFilterConfig.logLevel());
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean accept(LogEvent var1);
    }

    public static class Result {
        protected final List<LogEvent> caughtEvents = new ArrayList<LogEvent>();
        protected boolean noFilterFlag = false;

        public void assertHasEvent() {
            if (this.noFilterFlag) {
                throw new NoLogCaptureFilterException();
            }
            Assert.assertFalse((String)"No log result found", (boolean)this.caughtEvents.isEmpty());
        }

        public void clear() {
            this.caughtEvents.clear();
            this.noFilterFlag = false;
        }

        public List<LogEvent> getCaughtEvents() {
            return this.caughtEvents;
        }

        public List<String> getCaughtEventMessages() {
            return this.caughtEvents.stream().map(LogEvent::getMessage).map(Message::getFormattedMessage).collect(Collectors.toList());
        }
    }

    protected static class DefaultFilter
    implements Filter {
        protected final String loggerName;
        protected final Level logLevel;

        public DefaultFilter(String loggerName, String logLevel) {
            this.loggerName = StringUtils.stripToNull((String)loggerName);
            this.logLevel = StringUtils.isBlank((CharSequence)logLevel) ? null : Level.toLevel((String)logLevel);
        }

        @Override
        public boolean accept(LogEvent event) {
            if (this.logLevel != null && !this.logLevel.equals((Object)event.getLevel())) {
                return false;
            }
            return this.loggerName == null || this.loggerName.equals(event.getLoggerName());
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface FilterOn {
        public String loggerName() default "";

        public String logLevel() default "";

        public Class<?> loggerClass() default Object.class;
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface FilterWith {
        public Class<? extends Filter> value();
    }

    public static class NoLogCaptureFilterException
    extends AssertionError {
        private static final long serialVersionUID = 1L;
    }
}

