/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.logging;

import java.util.List;
import javax.inject.Inject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.LogFeature;
import org.nuxeo.runtime.test.runner.LoggerLevel;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class, LogFeature.class, LogCaptureFeature.class})
public class DeprecationLoggerTest {
    protected static final String MESSAGE = "Deprecation contribution on component: oldComponent should now be contributed to extension point: newExtension";
    protected static final String DEPRECATED_VERSION = "11.1";
    protected static String ORIGINAL_TESTING_PROPERTY_VALUE;
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;

    @BeforeClass
    public static void beforeAll() {
        ORIGINAL_TESTING_PROPERTY_VALUE = System.getProperty("org.nuxeo.runtime.testing");
    }

    @AfterClass
    public static void afterAll() {
        System.setProperty("org.nuxeo.runtime.testing", ORIGINAL_TESTING_PROPERTY_VALUE);
    }

    @Test
    @LogCaptureFeature.FilterOn(loggerClass=DeprecationLogger.class, logLevel="WARN")
    public void shouldLogMessageAsWarning() {
        this.logDeprecatedMessageAndVerify(true);
    }

    @Test
    @LogCaptureFeature.FilterOn(loggerClass=DeprecationLogger.class, logLevel="WARN")
    public void shouldNotLogMessageAsWarning() {
        System.setProperty("org.nuxeo.runtime.testing", "false");
        this.logDeprecatedMessageAndVerify(false);
    }

    @Test
    @LogCaptureFeature.FilterOn(loggerClass=DeprecationLogger.class, logLevel="INFO")
    @LoggerLevel(klass=DeprecationLogger.class, level="INFO")
    public void shouldLogMessageAsInfo() {
        System.setProperty("org.nuxeo.runtime.testing", "false");
        this.logDeprecatedMessageAndVerify(true);
    }

    @Test
    @LogCaptureFeature.FilterOn(loggerClass=DeprecationLogger.class, logLevel="INFO")
    @LoggerLevel(klass=DeprecationLogger.class, level="FATAL")
    public void shouldNotLogMessageAsInfo() {
        this.logDeprecatedMessageAndVerify(false);
    }

    protected void logDeprecatedMessageAndVerify(boolean messageShouldBeLogged) {
        DeprecationLogger.log((String)MESSAGE, (String)DEPRECATED_VERSION);
        List<String> caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        if (messageShouldBeLogged) {
            Assert.assertEquals((long)1L, (long)caughtEvents.size());
            Assert.assertEquals((Object)String.format("Since version %s: %s", DEPRECATED_VERSION, MESSAGE), (Object)caughtEvents.get(0));
        } else {
            Assert.assertTrue((boolean)caughtEvents.isEmpty());
        }
    }
}

