/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ExtensionImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.service.TimestampedService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ComponentInstanceImpl
implements ComponentInstance {
    private static final Log log = LogFactory.getLog(ComponentInstanceImpl.class);
    protected Object instance;
    protected RegistrationInfo ri;
    protected List<OSGiServiceFactory> factories;

    public ComponentInstanceImpl(RegistrationInfo ri) {
        this.ri = ri;
        this.instance = ri.getImplementation() == null ? this : this.createInstance();
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    public void create() {
        this.instance = this.ri.getImplementation() == null ? this : this.createInstance();
    }

    protected Object createInstance() {
        Object object;
        try {
            object = this.ri.getContext().loadClass(this.ri.getImplementation()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeServiceException(e);
        }
        if (object instanceof Component) {
            ((Component)object).setName(this.ri.getName().getName());
        }
        return object;
    }

    @Override
    public void destroy() {
        this.deactivate();
        this.instance = null;
        this.ri = null;
        this.factories = null;
    }

    @Override
    public RuntimeContext getContext() {
        return this.ri.getContext();
    }

    @Override
    public ComponentName getName() {
        return this.ri.getName();
    }

    @Override
    public void activate() {
        try {
            if (this.instance instanceof Component) {
                ((Component)this.instance).activate(this);
            } else if (this.instance != this) {
                Method meth = this.instance.getClass().getDeclaredMethod("activate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
            this.registerServices();
        }
        catch (NoSuchMethodException meth) {
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            this.handleError("Failed to activate component: " + this.getName(), e);
        }
    }

    @Override
    public void deactivate() {
        try {
            this.unregisterServices();
            if (this.instance instanceof Component) {
                ((Component)this.instance).deactivate(this);
            } else if (this.instance != this) {
                Method meth = this.instance.getClass().getDeclaredMethod("deactivate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
        }
        catch (NoSuchMethodException meth) {
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            this.handleError("Failed to deactivate component: " + this.getName(), e);
        }
    }

    @Override
    public void start() {
        if (this.instance instanceof Component) {
            ((Component)this.instance).start(this);
        }
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.instance instanceof Component) {
            ((Component)this.instance).stop(this);
        }
    }

    @Override
    @Deprecated
    public void reload() {
        try {
            Method meth = this.instance.getClass().getDeclaredMethod("reload", ComponentContext.class);
            meth.setAccessible(true);
            meth.invoke(this.instance, this);
        }
        catch (NoSuchMethodException meth) {
        }
        catch (ReflectiveOperationException e) {
            this.handleError("Failed to reload component: " + this.getName(), e);
        }
    }

    @Override
    public void registerExtension(Extension extension) {
        Optional<ExtensionPoint> optXp = this.ri.getExtensionPoint(extension.getExtensionPoint());
        if (optXp.isPresent()) {
            String superCo = optXp.get().getSuperComponent();
            if (superCo != null) {
                ((ExtensionImpl)extension).target = new ComponentName(superCo);
                ((RegistrationInfoImpl)this.ri).manager.registerExtension(extension);
                return;
            }
            if (this.instance instanceof Component) {
                ((Component)this.instance).registerExtension(extension);
            } else if (this.instance != this) {
                try {
                    Method meth = this.instance.getClass().getDeclaredMethod("registerExtension", Extension.class);
                    meth.setAccessible(true);
                    meth.invoke(this.instance, extension);
                }
                catch (ReflectiveOperationException e) {
                    this.handleError("Error registering " + extension.getComponent().getName(), e);
                }
            }
        } else {
            String message = "Warning: target extension point '" + extension.getExtensionPoint() + "' of '" + extension.getTargetComponent().getName() + "' is unknown. Check your extension in component " + extension.getComponent().getName();
            this.handleError(message, null);
        }
    }

    @Override
    public void unregisterExtension(Extension extension) {
        if (this.instance instanceof Component) {
            ((Component)this.instance).unregisterExtension(extension);
        } else if (this.instance != this) {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("unregisterExtension", Extension.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, extension);
            }
            catch (ReflectiveOperationException e) {
                this.handleError("Error unregistering " + extension.getComponent().getName(), e);
            }
        }
    }

    protected void handleError(String message, Exception e) {
        Exception ee = e;
        if (e != null) {
            ee = ExceptionUtils.unwrapInvoke((Exception)e);
        }
        log.error((Object)message, (Throwable)ee);
        Framework.getRuntime().getMessageHandler().addError(message);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        T res = null;
        Object object = this.getInstance();
        if (object == null) {
            return null;
        }
        if (object instanceof Adaptable) {
            res = ((Adaptable)object).getAdapter(adapter);
        } else if (adapter.isAssignableFrom(object.getClass())) {
            res = adapter.cast(object);
        }
        if (res instanceof TimestampedService && object instanceof TimestampedService) {
            Long lastModified = ((TimestampedService)object).getLastModified();
            ((TimestampedService)res).setLastModified(lastModified);
        }
        return res;
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> set = this.ri.getProperties().keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Property getProperty(String property) {
        return this.ri.getProperties().get(property);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ri.getContext();
    }

    @Override
    public Object getPropertyValue(String property) {
        return this.getPropertyValue(property, null);
    }

    @Override
    public Object getPropertyValue(String property, Object defValue) {
        Property prop = this.getProperty(property);
        if (prop != null) {
            return prop.getValue();
        }
        return defValue;
    }

    @Override
    public String[] getProvidedServiceNames() {
        return this.ri.getProvidedServiceNames();
    }

    public void registerServices() {
        if (!Framework.isOSGiServiceSupported()) {
            return;
        }
        String[] names = this.getProvidedServiceNames();
        if (names != null && names.length > 0) {
            this.factories = new ArrayList<OSGiServiceFactory>();
            for (String className : names) {
                OSGiServiceFactory factory = new OSGiServiceFactory(className);
                factory.register();
                this.factories.add(factory);
            }
        }
    }

    public void unregisterServices() {
        if (this.factories != null) {
            for (OSGiServiceFactory factory : this.factories) {
                factory.unregister();
            }
            this.factories = null;
        }
    }

    public String toString() {
        if (this.ri == null) {
            return super.toString();
        }
        return this.ri.toString();
    }

    @Override
    public RegistrationInfo getRegistrationInfo() {
        return this.ri;
    }

    protected class OSGiServiceFactory
    implements ServiceFactory {
        protected Class<?> clazz;
        protected ServiceRegistration reg;

        public OSGiServiceFactory(String className) {
            this(this$0.ri.getContext().getBundle(), className);
        }

        public OSGiServiceFactory(Bundle bundle, String className) {
            try {
                this.clazz = ComponentInstanceImpl.this.ri.getContext().getBundle().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeServiceException(e);
            }
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return ComponentInstanceImpl.this.getAdapter(this.clazz);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }

        public void register() {
            this.reg = ComponentInstanceImpl.this.ri.getContext().getBundle().getBundleContext().registerService(this.clazz.getName(), (Object)this, null);
        }

        public void unregister() {
            if (this.reg != null) {
                this.reg.unregister();
            }
            this.reg = null;
        }
    }
}

