/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.nuxeo.runtime.model.persistence.AbstractContribution;
import org.nuxeo.runtime.model.persistence.fs.FileSystemStorage;

public class ContributionFile
extends AbstractContribution {
    protected final File file;

    public ContributionFile(String name, File file) {
        super(name);
        this.file = file;
    }

    @Override
    public URL asURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getContent() {
        return FileSystemStorage.safeRead(this.file);
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.getContent().getBytes());
    }
}

