/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence;

import org.nuxeo.runtime.model.persistence.Contribution;
import org.nuxeo.runtime.model.persistence.ContributionPersistenceComponent;
import org.nuxeo.runtime.model.persistence.fs.FileSystemStorage;

public abstract class AbstractContribution
implements Contribution {
    protected String id;
    protected boolean loaded;
    protected final String name;
    protected String description;
    protected boolean disabled;

    protected AbstractContribution(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = ContributionPersistenceComponent.getComponentName(this.getName());
        }
        return this.id;
    }

    protected void load() {
        if (!this.loaded) {
            FileSystemStorage.loadMetadata(this);
            this.loaded = true;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        this.load();
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isDisabled() {
        this.load();
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }
}

