/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.core.ResourceDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.theme.styling.negotiation.Negotiator;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;
import org.nuxeo.theme.styling.service.descriptors.LogoDescriptor;
import org.nuxeo.theme.styling.service.descriptors.NegotiationDescriptor;
import org.nuxeo.theme.styling.service.descriptors.NegotiatorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PageDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;
import org.nuxeo.theme.styling.service.descriptors.SassImport;
import org.nuxeo.theme.styling.service.descriptors.SimpleStyle;
import org.nuxeo.theme.styling.service.palettes.PaletteParseException;
import org.nuxeo.theme.styling.service.palettes.PaletteParser;
import org.nuxeo.theme.styling.service.registries.FlavorRegistry;
import org.nuxeo.theme.styling.service.registries.NegotiationRegistry;
import org.nuxeo.theme.styling.service.registries.PageRegistry;

public class ThemeStylingServiceImpl
extends DefaultComponent
implements ThemeStylingService {
    private static final Log log = LogFactory.getLog(ThemeStylingServiceImpl.class);
    protected static final String WR_EX = "org.nuxeo.ecm.platform.WebResources";
    protected PageRegistry pageReg;
    protected FlavorRegistry flavorReg;
    protected NegotiationRegistry negReg;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.pageReg = new PageRegistry();
        this.flavorReg = new FlavorRegistry();
        this.negReg = new NegotiationRegistry();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof FlavorDescriptor) {
            FlavorDescriptor flavor = (FlavorDescriptor)contribution;
            log.info((Object)String.format("Register flavor '%s'", flavor.getName()));
            this.registerFlavor(flavor, contributor.getContext());
            log.info((Object)String.format("Done registering flavor '%s'", flavor.getName()));
        } else if (contribution instanceof SimpleStyle) {
            SimpleStyle style = (SimpleStyle)contribution;
            log.info((Object)String.format("Register style '%s'", style.getName()));
            ComponentName compName = contributor.getName();
            String message = String.format("Style '%s' on component %s should now be contributed to extension point '%s': a compatibility registration was performed but it may not be accurate. Note that the 'flavor' processor should be used with this resource.", style.getName(), compName, WR_EX);
            DeprecationLogger.log((String)message, (String)"7.4");
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
            ResourceDescriptor resource = this.getResourceFromStyle(style);
            this.registerResource((Resource)resource, contributor.getContext());
            log.info((Object)String.format("Done registering style '%s'", style.getName()));
        } else if (contribution instanceof PageDescriptor) {
            PageDescriptor page = (PageDescriptor)contribution;
            log.info((Object)String.format("Register page '%s'", page.getName()));
            if (page.hasResources()) {
                WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
                wrm.registerResourceBundle(page.getComputedResourceBundle());
            }
            this.pageReg.addContribution(page);
            log.info((Object)String.format("Done registering page '%s'", page.getName()));
        } else if (contribution instanceof ResourceDescriptor) {
            ResourceDescriptor resource = (ResourceDescriptor)contribution;
            log.info((Object)String.format("Register resource '%s'", resource.getName()));
            ComponentName compName = contributor.getName();
            String message = String.format("Resource '%s' on component %s should now be contributed to extension point '%s': a compatibility registration was performed but it may not be accurate.", resource.getName(), compName, WR_EX);
            DeprecationLogger.log((String)message, (String)"7.4");
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
            String path = resource.getPath();
            if (path != null && !path.startsWith("/")) {
                resource.setUri("/" + path);
            }
            this.registerResource((Resource)resource, contributor.getContext());
            log.info((Object)String.format("Done registering resource '%s'", resource.getName()));
        } else if (contribution instanceof NegotiationDescriptor) {
            NegotiationDescriptor neg = (NegotiationDescriptor)contribution;
            log.info((Object)String.format("Register negotiation for '%s'", neg.getTarget()));
            this.negReg.addContribution(neg);
            log.info((Object)String.format("Done registering negotiation for '%s'", neg.getTarget()));
        } else {
            log.error((Object)String.format("Unknown contribution to the theme styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof FlavorDescriptor) {
            FlavorDescriptor flavor = (FlavorDescriptor)contribution;
            this.flavorReg.removeContribution(flavor);
        } else if (contribution instanceof Resource) {
            Resource resource = (Resource)contribution;
            this.unregisterResource(resource);
        } else if (contribution instanceof SimpleStyle) {
            SimpleStyle style = (SimpleStyle)contribution;
            this.unregisterResource((Resource)this.getResourceFromStyle(style));
        } else if (contribution instanceof PageDescriptor) {
            PageDescriptor page = (PageDescriptor)contribution;
            if (page.hasResources()) {
                WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
                wrm.unregisterResourceBundle(page.getComputedResourceBundle());
            }
            this.pageReg.removeContribution(page);
        } else if (contribution instanceof NegotiationDescriptor) {
            NegotiationDescriptor neg = (NegotiationDescriptor)contribution;
            this.negReg.removeContribution(neg);
        } else {
            log.error((Object)String.format("Unknown contribution to the theme styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    protected void registerFlavor(FlavorDescriptor flavor, RuntimeContext extensionContext) {
        List<SassImport> sassVars;
        List<FlavorPresets> presets = flavor.getPresets();
        if (presets != null) {
            for (FlavorPresets myPreset : presets) {
                String content;
                String src = myPreset.getSrc();
                URL url = this.getUrlFromPath(src, extensionContext);
                if (url == null) {
                    log.error((Object)String.format("Could not find resource at '%s'", src));
                    continue;
                }
                try {
                    content = new String(IOUtils.toByteArray((URL)url));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                myPreset.setContent(content);
            }
        }
        if ((sassVars = flavor.getSassImports()) != null) {
            for (SassImport var : sassVars) {
                String content;
                String src = var.getSrc();
                URL url = this.getUrlFromPath(src, extensionContext);
                if (url == null) {
                    log.error((Object)String.format("Could not find resource at '%s'", src));
                    continue;
                }
                try {
                    content = new String(IOUtils.toByteArray((URL)url));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                var.setContent(content);
            }
        }
        this.flavorReg.addContribution(flavor);
    }

    protected List<FlavorPresets> computePresets(FlavorDescriptor flavor, List<String> flavors) {
        ArrayList<FlavorPresets> presets = new ArrayList<FlavorPresets>();
        if (flavor != null) {
            String extendsFlavorName;
            List<FlavorPresets> localPresets = flavor.getPresets();
            if (localPresets != null) {
                presets.addAll(localPresets);
            }
            if (!StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)("Cyclic dependency detected in flavor '" + flavor.getName() + "' hierarchy"));
                    return presets;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    List<FlavorPresets> parentPresets = this.computePresets(extendedFlavor, flavors);
                    if (parentPresets != null) {
                        presets.addAll(0, parentPresets);
                    }
                } else {
                    log.warn((Object)("Extended flavor '" + extendsFlavorName + "' not found"));
                }
            }
        }
        return presets;
    }

    protected void registerResource(Resource resource, RuntimeContext extensionContext) {
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        wrm.registerResource(resource);
    }

    protected void unregisterResource(Resource resource) {
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        wrm.unregisterResource(resource);
    }

    protected ResourceDescriptor getResourceFromStyle(SimpleStyle style) {
        ResourceDescriptor resource = new ResourceDescriptor();
        resource.setPath(style.getSrc());
        String name = style.getName();
        if (name.endsWith(ResourceType.css.name())) {
            resource.setName(name);
        } else {
            resource.setName(name + "." + ResourceType.css.name());
        }
        resource.setProcessors(Collections.singletonList("flavor"));
        return resource;
    }

    protected URL getUrlFromPath(String path, RuntimeContext extensionContext) {
        URL url;
        block3: {
            if (path == null) {
                return null;
            }
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                url = extensionContext.getLocalResource(path);
                if (url != null) break block3;
                url = extensionContext.getResource(path);
            }
        }
        return url;
    }

    @Override
    public String getDefaultFlavorName(String themePageName) {
        PageDescriptor themePage;
        if (this.pageReg != null && (themePage = this.pageReg.getPage(themePageName)) != null) {
            return themePage.getDefaultFlavor();
        }
        return null;
    }

    @Override
    public FlavorDescriptor getFlavor(String flavorName) {
        FlavorDescriptor flavor;
        if (this.flavorReg != null && (flavor = this.flavorReg.getFlavor(flavorName)) != null) {
            FlavorDescriptor clone = flavor.clone();
            clone.setLogo(this.computeLogo(flavor, new ArrayList<String>()));
            clone.setPalettePreview(this.computePalettePreview(flavor, new ArrayList<String>()));
            clone.setFavicons(this.computeIcons(flavor, new ArrayList<String>()));
            return clone;
        }
        return null;
    }

    @Override
    public LogoDescriptor getLogo(String flavorName) {
        FlavorDescriptor flavor = this.getFlavor(flavorName);
        if (flavor != null) {
            return flavor.getLogo();
        }
        return null;
    }

    protected LogoDescriptor computeLogo(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            LogoDescriptor localLogo = flavor.getLogo();
            if (localLogo == null && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)("Cyclic dependency detected in flavor '" + flavor.getName() + "' hierarchy"));
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localLogo = this.computeLogo(extendedFlavor, flavors);
                } else {
                    log.warn((Object)("Extended flavor '" + extendsFlavorName + "' not found"));
                }
            }
            return localLogo;
        }
        return null;
    }

    protected PalettePreview computePalettePreview(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            PalettePreview localPalette = flavor.getPalettePreview();
            if (localPalette == null && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)("Cyclic dependency detected in flavor '" + flavor.getName() + "' hierarchy"));
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localPalette = this.computePalettePreview(extendedFlavor, flavors);
                } else {
                    log.warn((Object)("Extended flavor '" + extendsFlavorName + "' not found"));
                }
            }
            return localPalette;
        }
        return null;
    }

    protected List<IconDescriptor> computeIcons(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            List<IconDescriptor> localIcons = flavor.getFavicons();
            if ((localIcons == null || localIcons.isEmpty()) && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)("Cyclic dependency detected in flavor '" + flavor.getName() + "' hierarchy"));
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localIcons = this.computeIcons(extendedFlavor, flavors);
                } else {
                    log.warn((Object)("Extended flavor '" + extendsFlavorName + "' not found"));
                }
            }
            return localIcons;
        }
        return null;
    }

    @Override
    public List<String> getFlavorNames(String themePageName) {
        PageDescriptor themePage;
        if (this.pageReg != null && (themePage = this.pageReg.getPage(themePageName)) != null) {
            String defaultFlavor;
            PageDescriptor forAllPage;
            ArrayList<String> flavors = new ArrayList<String>();
            List<String> localFlavors = themePage.getFlavors();
            if (localFlavors != null) {
                flavors.addAll(localFlavors);
            }
            if ((forAllPage = this.pageReg.getConfigurationApplyingToAll()) != null && (localFlavors = forAllPage.getFlavors()) != null) {
                flavors.addAll(localFlavors);
            }
            if ((defaultFlavor = themePage.getDefaultFlavor()) != null && !flavors.contains(defaultFlavor)) {
                flavors.add(0, defaultFlavor);
            }
            return flavors;
        }
        return null;
    }

    @Override
    public List<FlavorDescriptor> getFlavors(String themePageName) {
        List<String> flavorNames = this.getFlavorNames(themePageName);
        if (flavorNames != null) {
            ArrayList<FlavorDescriptor> flavors = new ArrayList<FlavorDescriptor>();
            for (String flavorName : flavorNames) {
                FlavorDescriptor flavor = this.getFlavor(flavorName);
                if (flavor == null) continue;
                flavors.add(flavor);
            }
            return flavors;
        }
        return null;
    }

    protected Map<String, Map<String, String>> getPresetsByCat(FlavorDescriptor flavor) {
        String flavorName = flavor.getName();
        List<FlavorPresets> presets = this.computePresets(flavor, new ArrayList<String>());
        HashMap<String, Map<String, String>> presetsByCat = new HashMap<String, Map<String, String>>();
        if (presets != null) {
            for (FlavorPresets myPreset : presets) {
                String content = myPreset.getContent();
                if (content == null) {
                    log.error((Object)("Null content for preset with source '" + myPreset.getSrc() + "' in flavor '" + flavorName + "'"));
                    continue;
                }
                String cat = myPreset.getCategory();
                Map allEntries = presetsByCat.containsKey(cat) ? (Map)presetsByCat.get(cat) : new HashMap();
                try {
                    Map<String, String> newEntries = PaletteParser.parse(content.getBytes(), myPreset.getSrc());
                    if (newEntries != null) {
                        allEntries.putAll(newEntries);
                    }
                    if (allEntries.isEmpty()) {
                        presetsByCat.remove(cat);
                        continue;
                    }
                    presetsByCat.put(cat, allEntries);
                }
                catch (PaletteParseException e) {
                    log.error((Object)String.format("Could not parse palette for preset with source '%s' in flavor '%s'", myPreset.getSrc(), flavorName), (Throwable)e);
                }
            }
        }
        return presetsByCat;
    }

    @Override
    public Map<String, String> getPresetVariables(String flavorName) {
        HashMap<String, String> res = new HashMap<String, String>();
        FlavorDescriptor flavor = this.getFlavor(flavorName);
        if (flavor == null) {
            return res;
        }
        Map<String, Map<String, String>> presetsByCat = this.getPresetsByCat(flavor);
        for (String cat : presetsByCat.keySet()) {
            Map<String, String> entries = presetsByCat.get(cat);
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                res.put(entry.getKey() + " (__FLAVOR__ " + cat + ")", entry.getValue());
            }
        }
        return res;
    }

    @Override
    public PageDescriptor getPage(String name) {
        PageDescriptor page = this.pageReg.getPage(name);
        if (page != null) {
            PageDescriptor globalPage = this.pageReg.getPage("*");
            this.mergePage(page, globalPage);
        }
        return page;
    }

    @Override
    public List<PageDescriptor> getPages() {
        ArrayList<PageDescriptor> pages = new ArrayList<PageDescriptor>();
        List<String> names = this.pageReg.getPageNames();
        PageDescriptor globalPage = this.pageReg.getPage("*");
        for (String name : names) {
            if ("*".equals(name)) continue;
            PageDescriptor page = this.pageReg.getPage(name);
            if (page != null) {
                this.mergePage(page, globalPage);
            }
            pages.add(page);
        }
        return pages;
    }

    protected void mergePage(PageDescriptor page, PageDescriptor globalPage) {
        if (page != null && globalPage != null) {
            PageDescriptor clone = globalPage.clone();
            clone.setAppendFlavors(true);
            clone.setAppendResources(true);
            clone.setAppendStyles(true);
            page.merge(clone);
        }
    }

    @Override
    public String negotiate(String target, Object context) {
        String res = null;
        NegotiationDescriptor negd = this.negReg.getNegotiation(target);
        if (negd != null) {
            List<NegotiatorDescriptor> nds = negd.getNegotiators();
            for (NegotiatorDescriptor nd : nds) {
                Class<Negotiator> ndc = nd.getNegotiatorClass();
                try {
                    Negotiator neg = ndc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    neg.setProperties(nd.getProperties());
                    res = neg.getResult(target, context);
                    if (res == null) continue;
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }
}

