/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Resource;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.SassImport;
import org.w3c.dom.Element;

public class FlavorRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(FlavorRegistry.class);

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        FlavorDescriptor flavor = (FlavorDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (flavor != null) {
            this.updateFlavor(flavor, ctx);
        }
        return (T)flavor;
    }

    protected void updateFlavor(FlavorDescriptor flavor, Context ctx) {
        List<FlavorPresets> presets = flavor.getPresets();
        for (FlavorPresets myPreset : presets) {
            if (myPreset.getContent() != null) continue;
            Resource resource = myPreset.getResource();
            try {
                myPreset.setContent(new String(IOUtils.toByteArray((URL)resource.toURL())));
            }
            catch (IOException e) {
                log.error("Could not find resource at '{}'", (Object)resource);
                myPreset.setContent("");
            }
        }
        List<SassImport> sassVars = flavor.getSassImports();
        for (SassImport var : sassVars) {
            if (var.getContent() != null) continue;
            Resource resource = var.getResource();
            try {
                var.setContent(new String(IOUtils.toByteArray((URL)resource.toURL())));
            }
            catch (IOException e) {
                log.error("Could not find resource at '{}'", (Object)resource);
                var.setContent("");
            }
        }
    }

    public List<FlavorDescriptor> getFlavorsExtending(String flavor) {
        return this.getContributionValues().stream().filter(f -> {
            String extendsFlavor = f.getExtendsFlavor();
            return !StringUtils.isBlank((CharSequence)extendsFlavor) && extendsFlavor.equals(flavor);
        }).collect(Collectors.toList());
    }
}

