/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.RedisEndpoint;
import com.redislabs.provider.redis.RedisEndpoint$;
import com.redislabs.provider.redis.RedisNode;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0017\tY!+\u001a3jg\u000e{gNZ5h\u0015\t\u0019A!A\u0003sK\u0012L7O\u0003\u0002\u0006\r\u0005A\u0001O]8wS\u0012,'O\u0003\u0002\b\u0011\u0005I!/\u001a3jg2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0003\u0001BC\u0002\u0013\u0005q#A\u0006j]&$\u0018.\u00197I_N$X#\u0001\r\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!!\u0004*fI&\u001cXI\u001c3q_&tG\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0019\u00031Ig.\u001b;jC2Dun\u001d;!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u00033\u0001AQA\u0006\u0010A\u0002aAq\u0001\n\u0001C\u0002\u0013\u0005Q%A\u0006j]&$\u0018.\u00197BI\u0012\u0014X#\u0001\u0014\u0011\u0005\u001dRcBA\u0007)\u0013\tIc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015\u000f\u0011\u0019q\u0003\u0001)A\u0005M\u0005a\u0011N\\5uS\u0006d\u0017\t\u001a3sA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014!\u00025pgR\u001cX#\u0001\u001a\u0011\u00075\u0019T'\u0003\u00025\u001d\t)\u0011I\u001d:bsB\u0011\u0011DN\u0005\u0003o\t\u0011\u0011BU3eSNtu\u000eZ3\t\re\u0002\u0001\u0015!\u00033\u0003\u0019Awn\u001d;tA!91\b\u0001b\u0001\n\u0003\t\u0014!\u00028pI\u0016\u001c\bBB\u001f\u0001A\u0003%!'\u0001\u0004o_\u0012,7\u000f\t\u0005\u0006\u007f\u0001!\t!J\u0001\bO\u0016$\u0018)\u001e;i\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u00159W\r\u001e#C+\u0005\u0019\u0005CA\u0007E\u0013\t)eBA\u0002J]RDQa\u0012\u0001\u0005\u0002!\u000bQbZ3u%\u0006tGm\\7O_\u0012,G#A\u001b\t\u000b)\u0003A\u0011A&\u0002\u001f\u001d,GOT8eKN\u0014\u0015p\u00157piN$2A\r'O\u0011\u0015i\u0015\n1\u0001D\u0003\u0011\u0019\bk\\:\t\u000b=K\u0005\u0019A\"\u0002\t\u0015\u0004vn\u001d\u0005\u0006#\u0002!\tAU\u0001\u0011G>tg.Z2uS>tgi\u001c:LKf$\"a\u0015/\u0011\u0005QSV\"A+\u000b\u0005Y;\u0016!\u00026fI&\u001c(B\u0001-Z\u0003\u001d\u0019G.[3oiNT\u0011aA\u0005\u00037V\u0013QAS3eSNDQ!\u0018)A\u0002\u0019\n1a[3z\u0011\u0015y\u0006\u0001\"\u0003a\u00039\u0019G.^:uKJ,e.\u00192mK\u0012$\"!\u00193\u0011\u00055\u0011\u0017BA2\u000f\u0005\u001d\u0011un\u001c7fC:DQA\u00060A\u0002aAQA\u001a\u0001\u0005\u0002\u001d\fqaZ3u\u0011>\u001cH\u000f\u0006\u00026Q\")Q,\u001aa\u0001M!)!\u000e\u0001C\u0005W\u0006Aq-\u001a;I_N$8\u000f\u0006\u00023Y\")a#\u001ba\u00011!)a\u000e\u0001C\u0005_\u0006\u0011r-\u001a;O_:\u001cE.^:uKJtu\u000eZ3t)\t\u0011\u0004\u000fC\u0003\u0017[\u0002\u0007\u0001\u0004C\u0003s\u0001\u0011%1/A\bhKR\u001cE.^:uKJtu\u000eZ3t)\t\u0011D\u000fC\u0003\u0017c\u0002\u0007\u0001\u0004C\u0003w\u0001\u0011\u0005q/\u0001\u0005hKRtu\u000eZ3t)\t\u0011\u0004\u0010C\u0003\u0017k\u0002\u0007\u0001\u0004")
public class RedisConfig
implements Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().dbNum();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.nodes()).filter((Function1)new Serializable(this, sPos, ePos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisConfig $outer;
            private final int sPos$1;
            private final int ePos$1;

            public final boolean apply(RedisNode node) {
                return this.$outer.com$redislabs$provider$redis$RedisConfig$$inter$1(this.sPos$1, this.ePos$1, node.startSlot(), node.endSlot());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sPos$1 = sPos$1;
                this.ePos$1 = ePos$1;
            }
        })).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$1) {
                return x$1.idx() == 0;
            }
        });
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version = ((String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains("redis_version:");
            }
        }))[0];
        String[] clusterEnable = (String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains("cluster_enabled:");
            }
        });
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return ((RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.hosts()).filter((Function1)new Serializable(this, slot){
            public static final long serialVersionUID = 0L;
            private final int slot$1;

            public final boolean apply(RedisNode host) {
                return host.startSlot() <= this.slot$1 && host.endSlot() >= this.slot$1;
            }
            {
                this.slot$1 = slot$1;
            }
        }))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$4) {
                return x$4.idx() == 0;
            }
        });
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return x$5.contains("role:slave");
                }
            })).length == 0) break;
            String host = ((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$6) {
                    return x$6.contains("master_host:");
                }
            }))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$7) {
                    return x$7.contains("master_port:");
                }
            }))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.dbNum(), RedisEndpoint$.MODULE$.$lessinit$greater$default$5());
        }
        Tuple2[] slaves = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x) {
                return x.contains("slave") && x.contains("online");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String rl) {
                String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
                String ip = content[0];
                String port = content[1];
                return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])slaves).$plus$colon((Object)tuple2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        int range = Predef$.MODULE$.refArrayOps((Object[])nodes).size();
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1)new Serializable(this, initialHost, nodes, range){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint initialHost$1;
            private final Tuple2[] nodes$1;
            private final int range$1;

            public final RedisNode apply(int i) {
                return new RedisNode(new RedisEndpoint((String)this.nodes$1[i]._1(), this.nodes$1[i]._2$mcI$sp(), this.initialHost$1.auth(), this.initialHost$1.dbNum(), this.initialHost$1.timeout()), 0, 16383, i, this.range$1);
            }
            {
                this.initialHost$1 = initialHost$1;
                this.nodes$1 = nodes$1;
                this.range$1 = range$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(conn.clusterSlots()).flatMap((Function1)new Serializable(this, initialHost){
            public static final long serialVersionUID = 0L;
            public final RedisEndpoint initialHost$2;

            public final IndexedSeq<RedisNode> apply(Object slotInfoObj) {
                List slotInfo = (List)slotInfoObj;
                int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
                int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1)new Serializable(this, slotInfo, sPos, ePos){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final List slotInfo$1;
                    private final int sPos$2;
                    private final int ePos$2;

                    public final RedisNode apply(int i) {
                        List node = (List)JavaConversions$.MODULE$.asScalaBuffer(this.slotInfo$1).apply(i + 2);
                        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
                        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
                        return new RedisNode(new RedisEndpoint(host, port, this.$outer.initialHost$2.auth(), this.$outer.initialHost$2.dbNum(), this.$outer.initialHost$2.timeout()), this.sPos$2, this.ePos$2, i, this.slotInfo$1.size() - 2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.slotInfo$1 = slotInfo$1;
                        this.sPos$2 = sPos$2;
                        this.ePos$2 = ePos$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.initialHost$2 = initialHost$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    public final boolean com$redislabs$provider$redis$RedisConfig$$inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

