/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisContext$;
import com.redislabs.provider.redis.RedisNode;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RedisContext$
implements Serializable {
    public static final RedisContext$ MODULE$;

    static {
        new RedisContext$();
    }

    public void setKVs(Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig) {
        Predef$.MODULE$.refArrayOps((Object[])arr.map((Function1)new Serializable(redisConfig){
            public static final long serialVersionUID = 0L;
            private final RedisConfig redisConfig$2;

            public final Tuple2<RedisNode, Tuple2<String, String>> apply(Tuple2<String, String> kv) {
                return new Tuple2((Object)this.redisConfig$2.getHost((String)kv._1()), kv);
            }
            {
                this.redisConfig$2 = redisConfig$2;
            }
        }).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RedisNode apply(Tuple2<RedisNode, Tuple2<String, String>> x$1) {
                return (RedisNode)x$1._1();
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String>[] apply(Tuple2<RedisNode, Tuple2<String, String>>[] a) {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Tuple2<RedisNode, Tuple2<String, String>> p) {
                        return (Tuple2)p._2();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
        }).foreach((Function1)new Serializable(ttl){
            public static final long serialVersionUID = 0L;
            public final int ttl$2;

            public final void apply(Tuple2<RedisNode, Tuple2<String, String>[]> x) {
                Jedis conn = ((RedisNode)x._1()).endpoint().connect();
                Pipeline pipeline = conn.pipelined();
                if (this.ttl$2 <= 0) {
                    Predef$.MODULE$.refArrayOps((Object[])x._2()).foreach((Function1)new Serializable(this, pipeline){
                        public static final long serialVersionUID = 0L;
                        private final Pipeline pipeline$1;

                        public final Response<String> apply(Tuple2<String, String> x) {
                            return this.pipeline$1.set((String)x._1(), (String)x._2());
                        }
                        {
                            this.pipeline$1 = pipeline$1;
                        }
                    });
                } else {
                    Predef$.MODULE$.refArrayOps((Object[])x._2()).foreach((Function1)new Serializable(this, pipeline){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.setKVs.4 $outer;
                        private final Pipeline pipeline$1;

                        public final Response<String> apply(Tuple2<String, String> x) {
                            return this.pipeline$1.setex((String)x._1(), this.$outer.ttl$2, (String)x._2());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.pipeline$1 = pipeline$1;
                        }
                    });
                }
                pipeline.sync();
                conn.close();
            }
            {
                this.ttl$2 = ttl$2;
            }
        });
    }

    public void setHash(String hashName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig) {
        Jedis conn = redisConfig.connectionForKey(hashName);
        Pipeline pipeline = conn.pipelined();
        arr.foreach((Function1)new Serializable(hashName, pipeline){
            public static final long serialVersionUID = 0L;
            private final String hashName$2;
            private final Pipeline pipeline$2;

            public final Response<Long> apply(Tuple2<String, String> x) {
                return this.pipeline$2.hset(this.hashName$2, (String)x._1(), (String)x._2());
            }
            {
                this.hashName$2 = hashName$2;
                this.pipeline$2 = pipeline$2;
            }
        });
        Object object = ttl > 0 ? pipeline.expire(hashName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setZset(String zsetName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig) {
        Jedis conn = redisConfig.connectionForKey(zsetName);
        Pipeline pipeline = conn.pipelined();
        arr.foreach((Function1)new Serializable(zsetName, pipeline){
            public static final long serialVersionUID = 0L;
            private final String zsetName$2;
            private final Pipeline pipeline$3;

            public final Response<Long> apply(Tuple2<String, String> x) {
                return this.pipeline$3.zadd(this.zsetName$2, new StringOps(Predef$.MODULE$.augmentString((String)x._2())).toDouble(), (String)x._1());
            }
            {
                this.zsetName$2 = zsetName$2;
                this.pipeline$3 = pipeline$3;
            }
        });
        Object object = ttl > 0 ? pipeline.expire(zsetName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setSet(String setName, Iterator<String> arr, int ttl, RedisConfig redisConfig) {
        Jedis conn = redisConfig.connectionForKey(setName);
        Pipeline pipeline = conn.pipelined();
        arr.foreach((Function1)new Serializable(setName, pipeline){
            public static final long serialVersionUID = 0L;
            private final String setName$2;
            private final Pipeline pipeline$4;

            public final Response<Long> apply(String x$2) {
                return this.pipeline$4.sadd(this.setName$2, new String[]{x$2});
            }
            {
                this.setName$2 = setName$2;
                this.pipeline$4 = pipeline$4;
            }
        });
        Object object = ttl > 0 ? pipeline.expire(setName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setList(String listName, Iterator<String> arr, int ttl, RedisConfig redisConfig) {
        Jedis conn = redisConfig.connectionForKey(listName);
        Pipeline pipeline = conn.pipelined();
        arr.foreach((Function1)new Serializable(listName, pipeline){
            public static final long serialVersionUID = 0L;
            private final String listName$2;
            private final Pipeline pipeline$5;

            public final Response<Long> apply(String x$3) {
                return this.pipeline$5.rpush(this.listName$2, new String[]{x$3});
            }
            {
                this.listName$2 = listName$2;
                this.pipeline$5 = pipeline$5;
            }
        });
        Object object = ttl > 0 ? pipeline.expire(listName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setFixedList(String key, int listSize, Iterator<String> arr, RedisConfig redisConfig) {
        Jedis conn = redisConfig.connectionForKey(key);
        Pipeline pipeline = conn.pipelined();
        arr.foreach((Function1)new Serializable(key, pipeline){
            public static final long serialVersionUID = 0L;
            private final String key$1;
            private final Pipeline pipeline$6;

            public final Response<Long> apply(String x$4) {
                return this.pipeline$6.lpush(this.key$1, new String[]{x$4});
            }
            {
                this.key$1 = key$1;
                this.pipeline$6 = pipeline$6;
            }
        });
        Object object = listSize > 0 ? pipeline.ltrim(key, 0L, (long)(listSize - 1)) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RedisContext$() {
        MODULE$ = this;
    }
}

