/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.loss;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.nn.Activation;
import ai.djl.training.loss.Loss;

public class SigmoidBinaryCrossEntropyLoss
extends Loss {
    private float weight;
    private boolean fromSigmoid;

    public SigmoidBinaryCrossEntropyLoss() {
        this("SigmoidBinaryCrossEntropyLoss");
    }

    public SigmoidBinaryCrossEntropyLoss(String name) {
        this(name, 1.0f, false);
    }

    public SigmoidBinaryCrossEntropyLoss(String name, float weight, boolean fromSigmoid) {
        super(name);
        this.weight = weight;
        this.fromSigmoid = fromSigmoid;
    }

    @Override
    public NDArray evaluate(NDList label, NDList prediction) {
        NDArray loss;
        NDArray pred = prediction.singletonOrThrow();
        NDArray lab = label.singletonOrThrow();
        lab = lab.reshape(pred.getShape());
        if (!this.fromSigmoid) {
            loss = Activation.relu(pred).sub(pred.mul(lab)).add(Activation.softrelu(pred.abs().neg()));
        } else {
            double eps = 1.0E-12;
            loss = pred.add(eps).log().mul(lab).add(NDArrays.sub(1.0, pred).add(eps).mul(NDArrays.sub(1.0, lab)));
        }
        if (this.weight != 1.0f) {
            loss = loss.mul(Float.valueOf(this.weight));
        }
        return loss.mean();
    }
}

