/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.helpers;

import java.util.HashMap;
import java.util.Map;

public class RevAiApiDeploymentConfiguration {
    private static final Map<RevAiApiDeployment, DeploymentConfig> RevAiApiDeploymentConfigMap = new HashMap<RevAiApiDeployment, DeploymentConfig>();

    public static DeploymentConfig getConfig(RevAiApiDeployment deployment) {
        return RevAiApiDeploymentConfigMap.get((Object)deployment);
    }

    static {
        RevAiApiDeploymentConfigMap.put(RevAiApiDeployment.US, new DeploymentConfig("https://api.rev.ai", "wss://api.rev.ai"));
        RevAiApiDeploymentConfigMap.put(RevAiApiDeployment.EU, new DeploymentConfig("https://ec1.api.rev.ai", "wss://ec1.api.rev.ai"));
    }

    public static class DeploymentConfig {
        private final String baseUrl;
        private final String baseWebsocketUrl;

        public DeploymentConfig(String baseUrl, String baseWebsocketUrl) {
            this.baseUrl = baseUrl;
            this.baseWebsocketUrl = baseWebsocketUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getBaseWebsocketUrl() {
            return this.baseWebsocketUrl;
        }
    }

    public static enum RevAiApiDeployment {
        US("US"),
        EU("EU");

        private final String value;

        private RevAiApiDeployment(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

