/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.sentimentanalysis;

import ai.rev.helpers.ClientHelper;
import ai.rev.sentimentanalysis.SentimentAnalysisInterface;
import ai.rev.sentimentanalysis.models.Sentiment;
import ai.rev.sentimentanalysis.models.SentimentAnalysisJob;
import ai.rev.sentimentanalysis.models.SentimentAnalysisJobOptions;
import ai.rev.sentimentanalysis.models.SentimentAnalysisResult;
import ai.rev.speechtotext.models.asynchronous.RevAiTranscript;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class SentimentAnalysisClient {
    private OkHttpClient client;
    public SentimentAnalysisInterface apiInterface;

    public SentimentAnalysisClient(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client, "sentiment_analysis", "v1");
        this.apiInterface = (SentimentAnalysisInterface)retrofit.create(SentimentAnalysisInterface.class);
    }

    public void closeConnection() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    public List<SentimentAnalysisJob> getListOfJobs(Integer limit, String startingAfter) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (startingAfter != null) {
            options.put("starting_after", startingAfter);
        }
        if (limit != null) {
            options.put("limit", String.valueOf(limit));
        }
        return (List)this.apiInterface.getListOfJobs(options).execute().body();
    }

    public List<SentimentAnalysisJob> getListOfJobs(Integer limit) throws IOException {
        return this.getListOfJobs(limit, null);
    }

    public List<SentimentAnalysisJob> getListOfJobs(String startingAfter) throws IOException {
        return this.getListOfJobs(null, startingAfter);
    }

    public List<SentimentAnalysisJob> getListOfJobs() throws IOException {
        return this.getListOfJobs(null, null);
    }

    public SentimentAnalysisJob getJobDetails(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        return (SentimentAnalysisJob)this.apiInterface.getJobDetails(id).execute().body();
    }

    public void deleteJob(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        this.apiInterface.deleteJob(id).execute();
    }

    public SentimentAnalysisResult getResultObject(String id, Sentiment filterFor) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("filter_for", filterFor.getSentiment());
        return (SentimentAnalysisResult)this.apiInterface.getResultObject(id, options).execute().body();
    }

    public SentimentAnalysisResult getResultObject(String id) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        return (SentimentAnalysisResult)this.apiInterface.getResultObject(id, options).execute().body();
    }

    public SentimentAnalysisJob submitJobText(String text, SentimentAnalysisJobOptions options) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException("Text must be provided");
        }
        if (options == null) {
            options = new SentimentAnalysisJobOptions();
        }
        options.setText(text);
        return (SentimentAnalysisJob)this.apiInterface.submitJob(options).execute().body();
    }

    public SentimentAnalysisJob submitJobText(String text) throws IOException {
        return this.submitJobText(text, null);
    }

    public SentimentAnalysisJob submitJobJson(RevAiTranscript json, SentimentAnalysisJobOptions options) throws IOException {
        if (json == null) {
            throw new IllegalArgumentException("Json must be provided");
        }
        if (options == null) {
            options = new SentimentAnalysisJobOptions();
        }
        options.setJson(json);
        return (SentimentAnalysisJob)this.apiInterface.submitJob(options).execute().body();
    }

    public SentimentAnalysisJob submitJobJson(RevAiTranscript json) throws IOException {
        return this.submitJobJson(json, null);
    }
}

