/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.speechtotext;

import ai.rev.helpers.ClientHelper;
import ai.rev.helpers.RevAiApiDeploymentConfiguration;
import ai.rev.speechtotext.ApiInterface;
import ai.rev.speechtotext.FileStreamRequestBody;
import ai.rev.speechtotext.models.asynchronous.RevAiAccount;
import ai.rev.speechtotext.models.asynchronous.RevAiCaptionType;
import ai.rev.speechtotext.models.asynchronous.RevAiJob;
import ai.rev.speechtotext.models.asynchronous.RevAiJobOptions;
import ai.rev.speechtotext.models.asynchronous.RevAiTranscript;
import ai.rev.speechtotext.models.asynchronous.Summary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;

public class ApiClient {
    private OkHttpClient client;
    public ApiInterface apiInterface;

    public ApiClient(String accessToken, String baseUrl) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client, "speechtotext", "v1", baseUrl != null ? baseUrl : RevAiApiDeploymentConfiguration.getConfig(RevAiApiDeploymentConfiguration.RevAiApiDeployment.US).getBaseUrl());
        this.apiInterface = (ApiInterface)retrofit.create(ApiInterface.class);
    }

    public ApiClient(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client, "speechtotext", "v1");
        this.apiInterface = (ApiInterface)retrofit.create(ApiInterface.class);
    }

    public void closeConnection() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    public RevAiAccount getAccount() throws IOException {
        return (RevAiAccount)this.apiInterface.getAccount().execute().body();
    }

    public List<RevAiJob> getListOfJobs(Integer limit, String startingAfter) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (startingAfter != null) {
            options.put("starting_after", startingAfter);
        }
        if (limit != null) {
            options.put("limit", String.valueOf(limit));
        }
        return (List)this.apiInterface.getListOfJobs(options).execute().body();
    }

    public List<RevAiJob> getListOfJobs(Integer limit) throws IOException {
        return this.getListOfJobs(limit, null);
    }

    public List<RevAiJob> getListOfJobs(String startingAfter) throws IOException {
        return this.getListOfJobs(null, startingAfter);
    }

    public List<RevAiJob> getListOfJobs() throws IOException {
        return this.getListOfJobs(null, null);
    }

    public RevAiJob getJobDetails(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        return (RevAiJob)this.apiInterface.getJobDetails(id).execute().body();
    }

    public void deleteJob(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        this.apiInterface.deleteJob(id).execute();
    }

    public RevAiTranscript getTranscriptObject(String id) throws IOException {
        return (RevAiTranscript)this.apiInterface.getTranscriptObject(id).execute().body();
    }

    public String getTranslatedTranscriptText(String id, String language) throws IOException {
        return (String)this.apiInterface.getTranslatedTranscriptText(id, language).execute().body();
    }

    public RevAiTranscript getTranslatedTranscriptObject(String id, String language) throws IOException {
        return (RevAiTranscript)this.apiInterface.getTranslatedTranscriptObject(id, language).execute().body();
    }

    public String getTranscriptText(String id) throws IOException {
        return (String)this.apiInterface.getTranscriptText(id).execute().body();
    }

    public String getTranscriptSummaryText(String id) throws IOException {
        return (String)this.apiInterface.getTranscriptSummaryText(id).execute().body();
    }

    public Summary getTranscriptSummaryObject(String id) throws IOException {
        return (Summary)this.apiInterface.getTranscriptSummaryObject(id).execute().body();
    }

    @Deprecated
    public RevAiJob submitJobUrl(String mediaUrl, RevAiJobOptions options) throws IOException {
        if (mediaUrl == null) {
            throw new IllegalArgumentException("Media url must be provided");
        }
        if (options == null) {
            options = new RevAiJobOptions();
        }
        options.setMediaUrl(mediaUrl);
        return (RevAiJob)this.apiInterface.submitJobUrl(options).execute().body();
    }

    public RevAiJob submitJobUrl(String mediaUrl) throws IOException {
        RevAiJobOptions options = new RevAiJobOptions();
        options.setSourceConfig(mediaUrl);
        return this.submitJobUrl(options);
    }

    public RevAiJob submitJobUrl(RevAiJobOptions options) throws IOException {
        return (RevAiJob)this.apiInterface.submitJobUrl(options).execute().body();
    }

    public RevAiJob submitJobLocalFile(String filePath, RevAiJobOptions options) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path must be provided");
        }
        if (options == null) {
            options = new RevAiJobOptions();
        }
        File file = new File(filePath);
        return this.submitMultipartRequest(new FileInputStream(file.getAbsoluteFile()), file.getName(), options);
    }

    public RevAiJob submitJobLocalFile(String filePath) throws IOException {
        return this.submitJobLocalFile(filePath, null);
    }

    public RevAiJob submitJobLocalFile(InputStream inputStream, String fileName, RevAiJobOptions options) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("File stream must be provided");
        }
        if (options == null) {
            options = new RevAiJobOptions();
        }
        if (fileName == null) {
            fileName = "audio_file";
        }
        return this.submitMultipartRequest(inputStream, fileName, options);
    }

    public RevAiJob submitJobLocalFile(InputStream inputStream) throws IOException {
        return this.submitJobLocalFile(inputStream, null, null);
    }

    public RevAiJob submitJobLocalFile(InputStream inputStream, String fileName) throws IOException {
        return this.submitJobLocalFile(inputStream, fileName, null);
    }

    public RevAiJob submitJobLocalFile(InputStream inputStream, RevAiJobOptions options) throws IOException {
        return this.submitJobLocalFile(inputStream, null, options);
    }

    public InputStream getCaptions(String id, RevAiCaptionType captionType, Integer channelId) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        if (channelId != null) {
            query.put("speaker_channel", channelId.toString());
        }
        if (captionType == null) {
            captionType = RevAiCaptionType.SRT;
        }
        HashMap<String, String> contentHeader = new HashMap<String, String>();
        contentHeader.put("Accept", captionType.getContentType());
        return ((ResponseBody)this.apiInterface.getCaptionText(id, query, contentHeader).execute().body()).byteStream();
    }

    public InputStream getTranslatedCaptions(String id, String language, RevAiCaptionType captionType) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        if (captionType == null) {
            captionType = RevAiCaptionType.SRT;
        }
        HashMap<String, String> contentHeader = new HashMap<String, String>();
        contentHeader.put("Accept", captionType.getContentType());
        return ((ResponseBody)this.apiInterface.getTranslatedCaptionText(id, language, query, contentHeader).execute().body()).byteStream();
    }

    public InputStream getCaptions(String id, RevAiCaptionType captionType) throws IOException {
        return this.getCaptions(id, captionType, null);
    }

    public InputStream getCaptions(String id, Integer channelId) throws IOException {
        return this.getCaptions(id, null, channelId);
    }

    public InputStream getCaptions(String id) throws IOException {
        return this.getCaptions(id, null, null);
    }

    private RevAiJob submitMultipartRequest(InputStream inputStream, String fileName, RevAiJobOptions options) throws IOException {
        RequestBody fileRequest = FileStreamRequestBody.create(inputStream, MediaType.parse((String)"audio/*"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"media", (String)fileName, (RequestBody)fileRequest);
        return (RevAiJob)this.apiInterface.submitJobLocalFile(filePart, options).execute().body();
    }
}

