/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.speechtotext;

import ai.rev.speechtotext.models.asynchronous.RevAiAccount;
import ai.rev.speechtotext.models.asynchronous.RevAiJob;
import ai.rev.speechtotext.models.asynchronous.RevAiJobOptions;
import ai.rev.speechtotext.models.asynchronous.RevAiTranscript;
import ai.rev.speechtotext.models.asynchronous.Summary;
import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface ApiInterface {
    public static final String REV_JSON_CONTENT_TYPE = "application/vnd.rev.transcript.v1.0+json";
    public static final String REV_TEXT_CONTENT_TYPE = "text/plain";

    @GET(value="account")
    public Call<RevAiAccount> getAccount();

    @GET(value="jobs/{id}")
    public Call<RevAiJob> getJobDetails(@Path(value="id") String var1);

    @GET(value="jobs")
    public Call<List<RevAiJob>> getListOfJobs(@QueryMap Map<String, String> var1);

    @Headers(value={"Accept: application/vnd.rev.transcript.v1.0+json"})
    @GET(value="jobs/{id}/transcript")
    public Call<RevAiTranscript> getTranscriptObject(@Path(value="id") String var1);

    @Headers(value={"Accept: text/plain"})
    @GET(value="jobs/{id}/transcript")
    public Call<String> getTranscriptText(@Path(value="id") String var1);

    @Headers(value={"Accept: application/vnd.rev.transcript.v1.0+json"})
    @GET(value="jobs/{id}/transcript/translation/{language}")
    public Call<RevAiTranscript> getTranslatedTranscriptObject(@Path(value="id") String var1, @Path(value="language") String var2);

    @Headers(value={"Accept: text/plain"})
    @GET(value="jobs/{id}/transcript/translation/{language}")
    public Call<String> getTranslatedTranscriptText(@Path(value="id") String var1, @Path(value="language") String var2);

    @Headers(value={"Accept: text/plain"})
    @GET(value="jobs/{id}/transcript/summary")
    public Call<String> getTranscriptSummaryText(@Path(value="id") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="jobs/{id}/transcript/summary")
    public Call<Summary> getTranscriptSummaryObject(@Path(value="id") String var1);

    @POST(value="jobs")
    public Call<RevAiJob> submitJobUrl(@Body RevAiJobOptions var1);

    @DELETE(value="jobs/{id}")
    public Call<Void> deleteJob(@Path(value="id") String var1);

    @Multipart
    @POST(value="jobs")
    public Call<RevAiJob> submitJobLocalFile(@Part MultipartBody.Part var1, @Part(value="options") RevAiJobOptions var2);

    @GET(value="jobs/{id}/captions")
    public Call<ResponseBody> getCaptionText(@Path(value="id") String var1, @QueryMap Map<String, String> var2, @HeaderMap Map<String, String> var3);

    @GET(value="jobs/{id}/captions/translation/{language}")
    public Call<ResponseBody> getTranslatedCaptionText(@Path(value="id") String var1, @Path(value="language") String var2, @QueryMap Map<String, String> var3, @HeaderMap Map<String, String> var4);
}

