/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.topicextraction;

import ai.rev.helpers.ClientHelper;
import ai.rev.speechtotext.models.asynchronous.RevAiTranscript;
import ai.rev.topicextraction.TopicExtractionInterface;
import ai.rev.topicextraction.models.TopicExtractionJob;
import ai.rev.topicextraction.models.TopicExtractionJobOptions;
import ai.rev.topicextraction.models.TopicExtractionResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class TopicExtractionClient {
    private OkHttpClient client;
    public TopicExtractionInterface apiInterface;

    public TopicExtractionClient(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client, "topic_extraction", "v1");
        this.apiInterface = (TopicExtractionInterface)retrofit.create(TopicExtractionInterface.class);
    }

    public void closeConnection() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    public List<TopicExtractionJob> getListOfJobs(Integer limit, String startingAfter) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (startingAfter != null) {
            options.put("starting_after", startingAfter);
        }
        if (limit != null) {
            options.put("limit", String.valueOf(limit));
        }
        return (List)this.apiInterface.getListOfJobs(options).execute().body();
    }

    public List<TopicExtractionJob> getListOfJobs(Integer limit) throws IOException {
        return this.getListOfJobs(limit, null);
    }

    public List<TopicExtractionJob> getListOfJobs(String startingAfter) throws IOException {
        return this.getListOfJobs(null, startingAfter);
    }

    public List<TopicExtractionJob> getListOfJobs() throws IOException {
        return this.getListOfJobs(null, null);
    }

    public TopicExtractionJob getJobDetails(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        return (TopicExtractionJob)this.apiInterface.getJobDetails(id).execute().body();
    }

    public void deleteJob(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        this.apiInterface.deleteJob(id).execute();
    }

    public TopicExtractionResult getResultObject(String id, Double threshold) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("threshold", threshold);
        return (TopicExtractionResult)this.apiInterface.getResultObject(id, options).execute().body();
    }

    public TopicExtractionResult getResultObject(String id) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        return (TopicExtractionResult)this.apiInterface.getResultObject(id, options).execute().body();
    }

    public TopicExtractionJob submitJobText(String text, TopicExtractionJobOptions options) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException("Text must be provided");
        }
        if (options == null) {
            options = new TopicExtractionJobOptions();
        }
        options.setText(text);
        return (TopicExtractionJob)this.apiInterface.submitJob(options).execute().body();
    }

    public TopicExtractionJob submitJobText(String text) throws IOException {
        return this.submitJobText(text, null);
    }

    public TopicExtractionJob submitJobJson(RevAiTranscript json, TopicExtractionJobOptions options) throws IOException {
        if (json == null) {
            throw new IllegalArgumentException("Json must be provided");
        }
        if (options == null) {
            options = new TopicExtractionJobOptions();
        }
        options.setJson(json);
        return (TopicExtractionJob)this.apiInterface.submitJob(options).execute().body();
    }

    public TopicExtractionJob submitJobJson(RevAiTranscript json) throws IOException {
        return this.submitJobJson(json, null);
    }
}

