/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.saveable.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.runtime.saveable.lint.RememberSaveableDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/runtime/saveable/lint/RememberSaveableDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "runtime-saveable-lint"})
@SourceDebugExtension(value={"SMAP\nRememberSaveableDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberSaveableDetector.kt\nandroidx/compose/runtime/saveable/lint/RememberSaveableDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n1549#2:137\n1620#2,3:138\n*S KotlinDebug\n*F\n+ 1 RememberSaveableDetector.kt\nandroidx/compose/runtime/saveable/lint/RememberSaveableDetector\n*L\n52#1:134\n52#1:135,2\n63#1:137\n63#1:138,3\n*E\n"})
public final class RememberSaveableDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue RememberSaveableSaverParameter = Issue.Companion.create("RememberSaveableSaverParameter", "`Saver` objects should be passed to the saver parameter, not the vararg `inputs` parameter", "The first parameter to `rememberSaveable` is a vararg parameter for inputs that when changed will cause the state to reset. Passing a `Saver` object to this parameter is an error, as the intention is to pass the `Saver` object to the saver parameter. Since the saver parameter is not the first parameter, it must be explicitly named.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(RememberSaveableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)RememberSaveableDetectorKt.access$getRememberSaveable$p().getShortName());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        LintFix lintFix;
        PsiType argumentType;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, RememberSaveableDetectorKt.access$getRuntimeSaveablePackageName$p())) {
            return;
        }
        Map argumentMapping = context.getEvaluator().computeArgumentMapping(node, method);
        Iterable $this$filter$iv = MapsKt.toList((Map)argumentMapping);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            PsiParameter parameter = (PsiParameter)pair.component2();
            if (!(parameter.getType() instanceof PsiArrayType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UExpression)it.getFirst());
        }
        List varargArguments = (List)destination$iv$iv;
        if (varargArguments.size() != 1) {
            return;
        }
        UExpression argument = (UExpression)CollectionsKt.first((List)varargArguments);
        PsiType psiType = argumentType = argument.getExpressionType();
        if (!(psiType != null ? PsiUtilsKt.inheritsFrom(psiType, RememberSaveableDetectorKt.access$getSaver$p()) : false)) {
            return;
        }
        destination$iv$iv = node.getExpressionType();
        boolean isMutableStateSaver = destination$iv$iv != null ? PsiUtilsKt.inheritsFrom((PsiType)destination$iv$iv, Names.Runtime.INSTANCE.getMutableState()) : false;
        String parameterName = isMutableStateSaver ? "stateSaver" : "saver";
        PsiElement psiElement = argument.getSourcePsi();
        String argumentText = psiElement != null ? psiElement.getText() : null;
        Object object = context;
        Issue issue = RememberSaveableSaverParameter;
        UElement uElement = (UElement)node;
        Location location = context.getLocation((UElement)argument);
        String string = "Passing `Saver` instance to vararg `inputs`";
        String string2 = argumentText;
        if (string2 != null) {
            Object item$iv$iv;
            item$iv$iv = string2;
            String string3 = string;
            Location location2 = location;
            UElement uElement2 = uElement;
            Issue issue2 = issue;
            collection = object;
            boolean bl = false;
            String replacement = parameterName + " = " + argumentText;
            LintFix lintFix2 = LintFix.Companion.create().replace().name("Change to `" + replacement + "`").text(argumentText).with(replacement).autoFix().build();
            object = collection;
            issue = issue2;
            uElement = uElement2;
            location = location2;
            string = string3;
            lintFix = lintFix2;
        } else {
            lintFix = null;
        }
        object.report(issue, uElement, location, string, lintFix);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/saveable/lint/RememberSaveableDetector$Companion;", "", "()V", "RememberSaveableSaverParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getRememberSaveableSaverParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-saveable-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getRememberSaveableSaverParameter() {
            return RememberSaveableSaverParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

