/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.manifest.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003JB\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/test/manifest/lint/GradleDebugConfigurationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "TargetConfigutation", "", "blockPrefixes", "", "supportedConfigurations", "", "checkDslPropertyAssignment", "", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "value", "parent", "parentParent", "valueCookie", "", "statementCookie", "getStringLiteralValue", "Companion", "ui-test-manifest-lint"})
@SourceDebugExtension(value={"SMAP\nGradleDebugConfigurationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDebugConfigurationDetector.kt\nandroidx/compose/ui/test/manifest/lint/GradleDebugConfigurationDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n1747#2,3:124\n1747#2,3:127\n*S KotlinDebug\n*F\n+ 1 GradleDebugConfigurationDetector.kt\nandroidx/compose/ui/test/manifest/lint/GradleDebugConfigurationDetector\n*L\n39#1:120\n39#1:121,3\n81#1:124,3\n89#1:127,3\n*E\n"})
public final class GradleDebugConfigurationDetector
extends Detector
implements GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> supportedConfigurations;
    @NotNull
    private final Set<String> blockPrefixes;
    @NotNull
    private final String TargetConfigutation;
    @NotNull
    private static final Issue ISSUE;

    /*
     * WARNING - void declaration
     */
    public GradleDebugConfigurationDetector() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new String[]{"implementation", "api", "compileOnly", "runtimeOnly", "annotationProcessor", "lintChecks", "lintPublish"};
        objectArray = SetsKt.setOf((Object[])objectArray);
        GradleDebugConfigurationDetector gradleDebugConfigurationDetector = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            collection.add(string2);
        }
        gradleDebugConfigurationDetector.supportedConfigurations = (List)destination$iv$iv;
        objectArray = new String[]{"android", "test"};
        this.blockPrefixes = SetsKt.setOf((Object[])objectArray);
        String string = "debugImplementation".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.TargetConfigutation = string;
    }

    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        block20: {
            block19: {
                boolean bl;
                block18: {
                    boolean bl2;
                    String it;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    String cleanedProperty;
                    block17: {
                        boolean bl3;
                        block16: {
                            String library = this.getStringLiteralValue(value);
                            if (!StringsKt.startsWith$default((String)library, (String)"androidx.compose.ui:ui-test-manifest", (boolean)false, (int)2, null)) {
                                return;
                            }
                            String string = property.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                            cleanedProperty = string;
                            $this$any$iv = this.supportedConfigurations;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!StringsKt.contains$default((CharSequence)cleanedProperty, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                    bl3 = true;
                                    break block16;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) {
                            return;
                        }
                        if (StringsKt.contains$default((CharSequence)cleanedProperty, (CharSequence)this.TargetConfigutation, (boolean)false, (int)2, null)) {
                            return;
                        }
                        $this$any$iv = this.blockPrefixes;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl5 = false;
                                if (!StringsKt.startsWith$default((String)cleanedProperty, (String)it, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block17;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block19;
                    $this$any$iv = this.supportedConfigurations;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl6 = false;
                            if (!StringsKt.startsWith$default((String)cleanedProperty, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block20;
            }
            Incident incident = IncidentKt.Incident((Context)((Context)context)).issue(ISSUE).location(context.getLocation(statementCookie)).message("Please use debugImplementation.").fix(this.fix().replace().text(property).with("debugImplementation").build());
            context.report(incident);
        }
    }

    private final String getStringLiteralValue(String value) {
        if (value.length() > 2 && (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null))) {
            String string = value.substring(1, value.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return "";
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(GradleDebugConfigurationDetector.class, Scope.GRADLE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"TestManifestGradleConfiguration", (String)"The ui-test-manifest library should be included using the debugImplementation configuration.", (String)"The androidx.compose.ui:ui-test-manifest dependency is needed for launching a Compose host, such as with createComposeRule. However, it only needs to be present in testing configurations therefore use this dependency with the debugImplementation configuration", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null).addMoreInfo("https://developer.android.com/jetpack/compose/testing#setup");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/test/manifest/lint/GradleDebugConfigurationDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-test-manifest-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

