/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.RestrictTo;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.SchemaEquality;
import androidx.room.migration.bundle.SchemaEqualityUtil;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0000H\u0016R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0005\u001a\u00020\u00068\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006#"}, d2={"Landroidx/room/migration/bundle/DatabaseBundle;", "Landroidx/room/migration/bundle/SchemaEquality;", "()V", "version", "", "identityHash", "", "entities", "", "Landroidx/room/migration/bundle/EntityBundle;", "views", "Landroidx/room/migration/bundle/DatabaseViewBundle;", "setupQueries", "(ILjava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getEntities", "()Ljava/util/List;", "entitiesByTableName", "", "getEntitiesByTableName", "()Ljava/util/Map;", "entitiesByTableName$delegate", "Lkotlin/Lazy;", "getIdentityHash", "()Ljava/lang/String;", "getVersion", "()I", "getViews", "viewsByName", "getViewsByName", "viewsByName$delegate", "buildCreateQueries", "isSchemaEqual", "", "other", "FtsEntityCreateComparator", "room-migration"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class DatabaseBundle
implements SchemaEquality<DatabaseBundle> {
    @SerializedName(value="version")
    private final int version;
    @SerializedName(value="identityHash")
    @NotNull
    private final String identityHash;
    @SerializedName(value="entities")
    @NotNull
    private final List<EntityBundle> entities;
    @SerializedName(value="views")
    @NotNull
    private final List<DatabaseViewBundle> views;
    @SerializedName(value="setupQueries")
    @NotNull
    private final List<String> setupQueries;
    @NotNull
    private final transient Lazy entitiesByTableName$delegate;
    @NotNull
    private final transient Lazy viewsByName$delegate;

    public DatabaseBundle(int version, @NotNull String identityHash, @NotNull List<? extends EntityBundle> entities, @NotNull List<? extends DatabaseViewBundle> views, @NotNull List<String> setupQueries) {
        Intrinsics.checkNotNullParameter((Object)identityHash, (String)"identityHash");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter(views, (String)"views");
        Intrinsics.checkNotNullParameter(setupQueries, (String)"setupQueries");
        this.version = version;
        this.identityHash = identityHash;
        this.entities = entities;
        this.views = views;
        this.setupQueries = setupQueries;
        this.entitiesByTableName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends EntityBundle>>(this){
            final /* synthetic */ DatabaseBundle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, EntityBundle> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getEntities();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    EntityBundle entityBundle = (EntityBundle)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getTableName(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.viewsByName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends DatabaseViewBundle>>(this){
            final /* synthetic */ DatabaseBundle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, DatabaseViewBundle> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getViews();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    DatabaseViewBundle databaseViewBundle = (DatabaseViewBundle)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getViewName(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public String getIdentityHash() {
        return this.identityHash;
    }

    @NotNull
    public List<EntityBundle> getEntities() {
        return this.entities;
    }

    @NotNull
    public List<DatabaseViewBundle> getViews() {
        return this.views;
    }

    @Deprecated(message="Marked deprecated to avoid usage in the codebase")
    public DatabaseBundle() {
        this(0, "", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @NotNull
    public Map<String, EntityBundle> getEntitiesByTableName() {
        Lazy lazy = this.entitiesByTableName$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<String, DatabaseViewBundle> getViewsByName() {
        Lazy lazy = this.viewsByName$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public List<String> buildCreateQueries() {
        List list;
        List $this$buildCreateQueries_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.getEntities(), (Comparator)new FtsEntityCreateComparator());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityBundle entityBundle = (EntityBundle)element$iv;
            boolean bl2 = false;
            $this$buildCreateQueries_u24lambda_u242.addAll(entityBundle.buildCreateQueries());
        }
        $this$forEach$iv = this.getViews();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle viewBundle = (DatabaseViewBundle)element$iv;
            boolean bl3 = false;
            $this$buildCreateQueries_u24lambda_u242.add(viewBundle.createView());
        }
        $this$buildCreateQueries_u24lambda_u242.addAll((Collection)this.setupQueries);
        return CollectionsKt.build((List)list);
    }

    @Override
    public boolean isSchemaEqual(@NotNull DatabaseBundle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return SchemaEqualityUtil.INSTANCE.checkSchemaEquality(this.getEntitiesByTableName(), other.getEntitiesByTableName()) && SchemaEqualityUtil.INSTANCE.checkSchemaEquality(this.getViewsByName(), other.getViewsByName());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Landroidx/room/migration/bundle/DatabaseBundle$FtsEntityCreateComparator;", "Ljava/util/Comparator;", "Landroidx/room/migration/bundle/EntityBundle;", "Lkotlin/Comparator;", "()V", "compare", "", "firstEntity", "secondEntity", "room-migration"})
    public static final class FtsEntityCreateComparator
    implements Comparator<EntityBundle> {
        @Override
        public int compare(@NotNull EntityBundle firstEntity, @NotNull EntityBundle secondEntity) {
            String contentTable;
            Intrinsics.checkNotNullParameter((Object)firstEntity, (String)"firstEntity");
            Intrinsics.checkNotNullParameter((Object)secondEntity, (String)"secondEntity");
            if (firstEntity instanceof FtsEntityBundle) {
                String contentTable2 = ((FtsEntityBundle)firstEntity).getFtsOptions().getContentTable();
                if (Intrinsics.areEqual((Object)contentTable2, (Object)secondEntity.getTableName())) {
                    return 1;
                }
            } else if (secondEntity instanceof FtsEntityBundle && Intrinsics.areEqual((Object)(contentTable = ((FtsEntityBundle)secondEntity).getFtsOptions().getContentTable()), (Object)firstEntity.getTableName())) {
                return -1;
            }
            return 0;
        }
    }
}

