/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.RestrictTo;
import androidx.room.Index;
import androidx.room.migration.bundle.BundleUtil;
import androidx.room.migration.bundle.SchemaEquality;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\b\u0017\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0007\b\u0013\u00a2\u0006\u0002\u0010\nB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0000H\u0016R\u001e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\b\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u000b\u001a\u00020\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/room/migration/bundle/IndexBundle;", "Landroidx/room/migration/bundle/SchemaEquality;", "name", "", "unique", "", "columnNames", "", "createSql", "(Ljava/lang/String;ZLjava/util/List;Ljava/lang/String;)V", "()V", "isUnique", "orders", "(Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getColumnNames", "()Ljava/util/List;", "getCreateSql", "()Ljava/lang/String;", "()Z", "getName", "getOrders", "create", "tableName", "isSchemaEqual", "other", "Companion", "room-migration"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class IndexBundle
implements SchemaEquality<IndexBundle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="name")
    @NotNull
    private final String name;
    @SerializedName(value="unique")
    private final boolean isUnique;
    @SerializedName(value="columnNames")
    @Nullable
    private final List<String> columnNames;
    @SerializedName(value="orders")
    @Nullable
    private final List<String> orders;
    @SerializedName(value="createSql")
    @NotNull
    private final String createSql;
    @NotNull
    public static final String DEFAULT_PREFIX = "index_";

    public IndexBundle(@NotNull String name, boolean isUnique, @Nullable List<String> columnNames, @Nullable List<String> orders, @NotNull String createSql) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)createSql, (String)"createSql");
        this.name = name;
        this.isUnique = isUnique;
        this.columnNames = columnNames;
        this.orders = orders;
        this.createSql = createSql;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    @Nullable
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Nullable
    public List<String> getOrders() {
        return this.orders;
    }

    @NotNull
    public String getCreateSql() {
        return this.createSql;
    }

    @Deprecated(message="Use {@link #IndexBundle(String, boolean, List, List, String)}")
    public IndexBundle(@NotNull String name, boolean unique, @NotNull List<String> columnNames, @NotNull String createSql) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        Intrinsics.checkNotNullParameter((Object)createSql, (String)"createSql");
        this(name, unique, columnNames, null, createSql);
    }

    @Deprecated(message="Marked deprecated to avoid usage in the codebase")
    private IndexBundle() {
        this("", false, CollectionsKt.emptyList(), CollectionsKt.emptyList(), "");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public String create(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return BundleUtil.replaceTableName(this.getCreateSql(), tableName);
    }

    @NotNull
    public String getCreateSql(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return BundleUtil.replaceTableName(this.getCreateSql(), tableName);
    }

    @Override
    public boolean isSchemaEqual(@NotNull IndexBundle other) {
        List otherOrders;
        List list;
        List list2;
        int n;
        ArrayList<String> arrayList;
        int n2;
        int n3;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.isUnique() != other.isUnique()) {
            return false;
        }
        if (StringsKt.startsWith$default((String)this.getName(), (String)DEFAULT_PREFIX, (boolean)false, (int)2, null)) {
            if (!StringsKt.startsWith$default((String)other.getName(), (String)DEFAULT_PREFIX, (boolean)false, (int)2, null)) {
                return false;
            }
        } else {
            if (StringsKt.startsWith$default((String)other.getName(), (String)DEFAULT_PREFIX, (boolean)false, (int)2, null)) {
                return false;
            }
            if (!this.getName().equals(other.getName())) {
                return false;
            }
        }
        List<String> list3 = this.getColumnNames();
        if (list3 != null) {
            List<String> it = list3;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual(this.getColumnNames(), other.getColumnNames());
        } else {
            bl = other.getColumnNames() != null;
        }
        if (bl) {
            return false;
        }
        List<String> list4 = this.getColumnNames();
        int columnsSize = list4 != null ? list4.size() : 0;
        ArrayList<String> arrayList2 = (ArrayList<String>)this.getOrders();
        if (arrayList2 == null || arrayList2.isEmpty()) {
            arrayList2 = new ArrayList<String>(columnsSize);
            int n4 = 0;
            while (n4 < columnsSize) {
                n2 = n3 = n4++;
                arrayList = arrayList2;
                n = 0;
                arrayList.add(Index.Order.ASC.name());
            }
            list2 = arrayList2;
        } else {
            list2 = this.getOrders();
        }
        List orders = list2;
        ArrayList arrayList3 = (ArrayList)other.getOrders();
        if (arrayList3 == null || arrayList3.isEmpty()) {
            arrayList3 = new ArrayList(columnsSize);
            n3 = 0;
            while (n3 < columnsSize) {
                n = n2 = n3++;
                arrayList = arrayList3;
                boolean bl3 = false;
                arrayList.add(Index.Order.ASC.name());
            }
            list = arrayList3;
        } else {
            list = otherOrders = other.getOrders();
        }
        return Intrinsics.areEqual((Object)orders, otherOrders);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/migration/bundle/IndexBundle$Companion;", "", "()V", "DEFAULT_PREFIX", "", "room-migration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

