/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class PickerActions {
    public static ViewAction setDate(final int year, int monthOfYear, final int dayOfMonth) {
        final int normalizedMonthOfYear = monthOfYear - 1;
        return new ViewAction(){

            public String getDescription() {
                return "set date";
            }

            public Matcher<View> getConstraints() {
                return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(DatePicker.class), (Matcher)ViewMatchers.isDisplayed());
            }

            public void perform(UiController uiController, View view) {
                DatePicker datePicker = (DatePicker)view;
                datePicker.updateDate(year, normalizedMonthOfYear, dayOfMonth);
            }
        };
    }

    public static ViewAction setTime(final int hours, final int minutes) {
        return new ViewAction(){

            public String getDescription() {
                return "set time";
            }

            public Matcher<View> getConstraints() {
                return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(TimePicker.class), (Matcher)ViewMatchers.isDisplayed());
            }

            public void perform(UiController uiController, View view) {
                TimePicker timePicker = (TimePicker)view;
                timePicker.setCurrentHour(Integer.valueOf(hours));
                timePicker.setCurrentMinute(Integer.valueOf(minutes));
            }
        };
    }

    private PickerActions() {
    }
}

