/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.contrib.Checks;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RecyclerViewActions {
    private static final int NO_POSITION = -1;

    public static <VH extends RecyclerView.ViewHolder> ViewAction actionOnItemAtPosition(int position, ViewAction viewAction) {
        return new ActionOnItemAtPositionViewAction(position, viewAction);
    }

    @NonNull
    public static <VH extends RecyclerView.ViewHolder> ViewAction scrollToLastPosition() {
        return new ScrollToLastPositionViewAction();
    }

    public static <VH extends RecyclerView.ViewHolder> ViewAction scrollToPosition(int position) {
        return new ScrollToPositionViewAction(position);
    }

    public static <VH extends RecyclerView.ViewHolder> PositionableRecyclerViewAction actionOnHolderItem(Matcher<VH> viewHolderMatcher, ViewAction viewAction) {
        return new ActionOnItemViewAction(viewHolderMatcher, viewAction);
    }

    public static <VH extends RecyclerView.ViewHolder> PositionableRecyclerViewAction actionOnItem(Matcher<View> itemViewMatcher, ViewAction viewAction) {
        Matcher<VH> viewHolderMatcher = RecyclerViewActions.viewHolderMatcher(itemViewMatcher);
        return new ActionOnItemViewAction(viewHolderMatcher, viewAction);
    }

    public static <VH extends RecyclerView.ViewHolder> PositionableRecyclerViewAction scrollTo(Matcher<View> itemViewMatcher) {
        Matcher<VH> viewHolderMatcher = RecyclerViewActions.viewHolderMatcher(itemViewMatcher);
        return new ScrollToViewAction(viewHolderMatcher);
    }

    public static <VH extends RecyclerView.ViewHolder> PositionableRecyclerViewAction scrollToHolder(Matcher<VH> viewHolderMatcher) {
        return new ScrollToViewAction(viewHolderMatcher);
    }

    private static <T extends VH, VH extends RecyclerView.ViewHolder> List<MatchedItem> itemsMatching(RecyclerView recyclerView, Matcher<VH> viewHolderMatcher, int max) {
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        SparseArray viewHolderCache = new SparseArray();
        ArrayList<MatchedItem> matchedItems = new ArrayList<MatchedItem>();
        for (int position = 0; position < adapter.getItemCount(); ++position) {
            int itemType = adapter.getItemViewType(position);
            RecyclerView.ViewHolder cachedViewHolder = (RecyclerView.ViewHolder)viewHolderCache.get(itemType);
            if (null == cachedViewHolder) {
                cachedViewHolder = adapter.createViewHolder((ViewGroup)recyclerView, itemType);
                viewHolderCache.put(itemType, (Object)cachedViewHolder);
            }
            adapter.bindViewHolder(cachedViewHolder, position);
            if (viewHolderMatcher.matches((Object)cachedViewHolder)) {
                int n = position;
                matchedItems.add(new MatchedItem(position, HumanReadables.getViewHierarchyErrorMessage((View)cachedViewHolder.itemView, null, (String)("\n\n*** Matched ViewHolder item at position: " + n + " ***"), null)));
                adapter.onViewRecycled(cachedViewHolder);
                if (matchedItems.size() != max) continue;
                break;
            }
            adapter.onViewRecycled(cachedViewHolder);
        }
        return matchedItems;
    }

    private static <VH extends RecyclerView.ViewHolder> Matcher<VH> viewHolderMatcher(final Matcher<View> itemViewMatcher) {
        return new TypeSafeMatcher<VH>(){

            public void describeTo(Description description) {
                description.appendText("holder with view: ");
                itemViewMatcher.describeTo(description);
            }

            public boolean matchesSafely(RecyclerView.ViewHolder viewHolder) {
                return itemViewMatcher.matches((Object)viewHolder.itemView);
            }
        };
    }

    private RecyclerViewActions() {
    }

    private static final class ScrollToViewAction<VH extends RecyclerView.ViewHolder>
    implements PositionableRecyclerViewAction {
        private final Matcher<VH> viewHolderMatcher;
        private final int atPosition;

        @Override
        public PositionableRecyclerViewAction atPosition(int position) {
            Checks.checkArgument(position >= 0, "%d is used as an index - must be >= 0", position);
            return new ScrollToViewAction<VH>(this.viewHolderMatcher, position);
        }

        public String getDescription() {
            if (this.atPosition == -1) {
                String string = String.valueOf(this.viewHolderMatcher);
                return "scroll RecyclerView to: " + string;
            }
            return String.format("scroll RecyclerView to the: %dth matching %s.", this.atPosition, this.viewHolderMatcher);
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        private ScrollToViewAction(Matcher<VH> viewHolderMatcher) {
            this(viewHolderMatcher, -1);
        }

        private ScrollToViewAction(Matcher<VH> viewHolderMatcher, int atPosition) {
            this.viewHolderMatcher = viewHolderMatcher;
            this.atPosition = atPosition;
        }

        public void perform(UiController uiController, View view) {
            RecyclerView recyclerView = (RecyclerView)view;
            try {
                int maxMatches = this.atPosition == -1 ? 2 : this.atPosition + 1;
                int selectIndex = this.atPosition == -1 ? 0 : this.atPosition;
                List matchedItems = RecyclerViewActions.itemsMatching(recyclerView, this.viewHolderMatcher, maxMatches);
                if (selectIndex >= matchedItems.size()) {
                    throw new RuntimeException(String.format("Found %d items matching %s, but position %d was requested.", matchedItems.size(), this.viewHolderMatcher.toString(), this.atPosition));
                }
                if (this.atPosition == -1 && matchedItems.size() == 2) {
                    StringBuilder ambiguousViewError = new StringBuilder();
                    ambiguousViewError.append(String.format("Found more than one sub-view matching %s", this.viewHolderMatcher));
                    for (MatchedItem item : matchedItems) {
                        String string = String.valueOf(item);
                        ambiguousViewError.append(string + "\n");
                    }
                    throw new RuntimeException(ambiguousViewError.toString());
                }
                recyclerView.scrollToPosition(((MatchedItem)matchedItems.get((int)selectIndex)).position);
                uiController.loopMainThreadUntilIdle();
            }
            catch (RuntimeException e) {
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)view)).withCause((Throwable)e).build();
            }
        }
    }

    private static final class ScrollToPositionViewAction
    implements ViewAction {
        private final int position;

        public String getDescription() {
            int n = this.position;
            return "scroll RecyclerView to position: " + n;
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        private ScrollToPositionViewAction(int position) {
            this.position = position;
        }

        public void perform(UiController uiController, View view) {
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.scrollToPosition(this.position);
            uiController.loopMainThreadUntilIdle();
        }
    }

    private static final class ScrollToLastPositionViewAction
    implements ViewAction {
        public String getDescription() {
            return "scroll RecyclerView to last position";
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        private ScrollToLastPositionViewAction() {
        }

        public void perform(UiController uiController, View view) {
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.scrollToPosition(recyclerView.getAdapter().getItemCount() - 1);
        }
    }

    private static final class ActionOnItemViewAction<VH extends RecyclerView.ViewHolder>
    implements PositionableRecyclerViewAction {
        private final Matcher<VH> viewHolderMatcher;
        private final ViewAction viewAction;
        private final int atPosition;
        private final ScrollToViewAction<VH> scroller;

        @Override
        public PositionableRecyclerViewAction atPosition(int position) {
            Checks.checkArgument(position >= 0, "%d is used as an index - must be >= 0", position);
            return new ActionOnItemViewAction<VH>(this.viewHolderMatcher, this.viewAction, position);
        }

        public String getDescription() {
            if (this.atPosition == -1) {
                return String.format("performing ViewAction: %s on item matching: %s", this.viewAction.getDescription(), this.viewHolderMatcher);
            }
            return String.format("performing ViewAction: %s on %d-th item matching: %s", this.viewAction.getDescription(), this.atPosition, this.viewHolderMatcher);
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        private ActionOnItemViewAction(Matcher<VH> viewHolderMatcher, ViewAction viewAction) {
            this(viewHolderMatcher, viewAction, -1);
        }

        private ActionOnItemViewAction(Matcher<VH> viewHolderMatcher, ViewAction viewAction, int atPosition) {
            this.viewHolderMatcher = Checks.checkNotNull(viewHolderMatcher);
            this.viewAction = Checks.checkNotNull(viewAction);
            this.atPosition = atPosition;
            this.scroller = new ScrollToViewAction(viewHolderMatcher, atPosition);
        }

        public void perform(UiController uiController, View root) {
            RecyclerView recyclerView = (RecyclerView)root;
            try {
                this.scroller.perform(uiController, root);
                uiController.loopMainThreadUntilIdle();
                int max = this.atPosition == -1 ? 2 : this.atPosition + 1;
                int selectIndex = this.atPosition == -1 ? 0 : this.atPosition;
                List matchedItems = RecyclerViewActions.itemsMatching(recyclerView, this.viewHolderMatcher, max);
                RecyclerViewActions.actionOnItemAtPosition(((MatchedItem)matchedItems.get((int)selectIndex)).position, this.viewAction).perform(uiController, root);
                uiController.loopMainThreadUntilIdle();
            }
            catch (RuntimeException e) {
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)root)).withCause((Throwable)e).build();
            }
        }
    }

    private static final class ActionOnItemAtPositionViewAction<VH extends RecyclerView.ViewHolder>
    implements ViewAction {
        private final int position;
        private final ViewAction viewAction;

        public String getDescription() {
            int n = this.position;
            String string = this.viewAction.getDescription();
            return "actionOnItemAtPosition performing ViewAction: " + string + " on item at position: " + n;
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        private ActionOnItemAtPositionViewAction(int position, ViewAction viewAction) {
            this.position = position;
            this.viewAction = viewAction;
        }

        public void perform(UiController uiController, View view) {
            RecyclerView recyclerView = (RecyclerView)view;
            new ScrollToPositionViewAction(this.position).perform(uiController, view);
            uiController.loopMainThreadUntilIdle();
            RecyclerView.ViewHolder viewHolderForPosition = recyclerView.findViewHolderForAdapterPosition(this.position);
            if (null == viewHolderForPosition) {
                int n = this.position;
                throw new PerformException.Builder().withActionDescription(this.toString()).withViewDescription(HumanReadables.describe((View)view)).withCause((Throwable)new IllegalStateException("No view holder at position: " + n)).build();
            }
            View viewAtPosition = viewHolderForPosition.itemView;
            if (null == viewAtPosition) {
                int n = this.position;
                throw new PerformException.Builder().withActionDescription(this.toString()).withViewDescription(HumanReadables.describe((View)viewAtPosition)).withCause((Throwable)new IllegalStateException("No view at position: " + n)).build();
            }
            this.viewAction.perform(uiController, viewAtPosition);
        }
    }

    private static class MatchedItem {
        public final int position;
        public final String description;

        public String toString() {
            return this.description;
        }

        private MatchedItem(int position, String description) {
            this.position = position;
            this.description = description;
        }
    }

    public static interface PositionableRecyclerViewAction
    extends ViewAction {
        public PositionableRecyclerViewAction atPosition(int var1);
    }
}

