/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.remote.NoRemoteEspressoInstanceException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

final class InteractionResultsHandler {
    private static final String TAG = "InteractionResultsHandl";
    private static final int LOCAL_OR_REMOTE_ERROR_PRIORITY = Integer.MAX_VALUE;

    private InteractionResultsHandler() {
    }

    static <T> T gatherAnyResult(List<ListenableFuture<T>> tasks) {
        return InteractionResultsHandler.gatherAnyResult(tasks, MoreExecutors.directExecutor());
    }

    /*
     * Unable to fully structure code
     */
    static <T> T gatherAnyResult(List<ListenableFuture<T>> tasks, Executor executor) {
        block14: {
            Preconditions.checkNotNull(tasks);
            if (var0.isEmpty()) break block14;
            var2_6 = 1;
lbl5:
            // 2 sources

            while (true) {
                Preconditions.checkState((boolean)var2_6);
                var2_6 = var0.size();
                var3_8 = new LinkedBlockingQueue<E>(var2_6);
                var4_9 = var0.iterator();
                while (var4_9.hasNext()) {
                    var5_11 = var4_9.next();
                    var6_12 = new Runnable(){

                        @Override
                        public void run() {
                            if (var5_11.isCancelled()) {
                                return;
                            }
                            var3_8.offer(InteractionResultsHandler.adaptResult(var5_11));
                        }
                    };
                    var5_11.addListener(var6_12, (Executor)var1_1);
                }
                var1_2 = var2_6;
                var2_7 = null;
                while (true) {
                    block13: {
                        block15: {
                            if (var1_2 == 0) break block15;
                            if (var2_7 == null) break block13;
                            var4_10 = var2_7.isPriority();
                            if (!var4_10) break block13;
                        }
                        var1_3 = InteractionResultsHandler.finalResult(var2_7);
                        var0 = var0.iterator();
                        while (var0.hasNext()) {
                            var0.next().cancel(true);
                        }
                        return var1_3;
                    }
                    var4_9 = (ExecutionResult)var3_8.take();
                    --var1_2;
                    var2_7 = InteractionResultsHandler.pickResult(var2_7, var4_9);
                    continue;
                    break;
                }
                break;
            }
        }
        var2_6 = 0;
        ** while (true)
        catch (InterruptedException var1_4) {
            try {
                var2_7 = new ExecutionResult<T>("Interrupted while interacting", (Throwable)var1_4);
                throw var2_7;
            }
            catch (Throwable var1_5) {
                var0 = var0.iterator();
                while (true) {
                    if (!var0.hasNext()) {
                        throw var1_5;
                    }
                    var0.next().cancel(true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T> T finalResult(ExecutionResult<T> result) {
        Object object;
        if (result.isSuccess()) {
            return ((ExecutionResult)object).getResult();
        }
        Throwable throwable = ((ExecutionResult)object).getFailure();
        if (throwable instanceof ExecutionException) {
            if ((throwable = throwable.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        } else {
            if (throwable instanceof InterruptedException) {
                object = new IllegalStateException("Interrupted while interacting remotely", throwable);
                throw object;
            }
            object = new RuntimeException("Error interacting remotely", throwable);
            throw object;
        }
        if (!(throwable instanceof Error)) {
            throwable = new RuntimeException("Unknown error during interactions", ((ExecutionResult)object).getFailure());
            throw throwable;
        }
        throw (Error)throwable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> ExecutionResult<T> adaptResult(Future<T> task) {
        boolean bl;
        try {
            Object object;
            Preconditions.checkState(task.isDone());
            return ExecutionResult.success(object.get());
        }
        catch (ExecutionException executionException) {
            if (InteractionResultsHandler.getPriority(executionException) == Integer.MAX_VALUE) {
                bl = true;
                return ExecutionResult.error(executionException, bl);
            }
        }
        catch (InterruptedException interruptedException) {
            return ExecutionResult.error(interruptedException);
        }
        catch (RuntimeException runtimeException) {
            return ExecutionResult.error(runtimeException);
        }
        catch (Error error) {
            return ExecutionResult.error(error);
        }
        bl = false;
        return ExecutionResult.error(executionException, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> ExecutionResult<T> pickResult(ExecutionResult<T> one, ExecutionResult<T> two) {
        void var1_1;
        ExecutionResult<T> executionResult;
        if (two == null) {
            return executionResult;
        }
        if (executionResult == null) {
            return var1_1;
        }
        if (executionResult.isSuccess()) {
            return executionResult;
        }
        if (var1_1.isSuccess()) {
            return var1_1;
        }
        if (InteractionResultsHandler.getPriority(executionResult.getFailure()) > InteractionResultsHandler.getPriority(var1_1.getFailure())) {
            return executionResult;
        }
        return var1_1;
    }

    private static int getPriority(Throwable t) {
        Throwable throwable;
        if (t == null) {
            return Integer.MIN_VALUE;
        }
        if (!(throwable instanceof ExecutionException)) {
            return -2147483647;
        }
        if (throwable.getCause() instanceof NoRemoteEspressoInstanceException) {
            return 0;
        }
        if (throwable.getCause() instanceof NoActivityResumedException) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static class ExecutionResult<T> {
        private final T result;
        private final boolean success;
        private final Throwable failure;
        private final boolean priority;

        /*
         * WARNING - void declaration
         */
        private ExecutionResult(T result, boolean success, Throwable failure, boolean priority) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.result = var1_1;
            this.success = var2_2;
            this.failure = var3_3;
            this.priority = var4_4;
        }

        public T getResult() {
            Preconditions.checkState(this.success);
            return this.result;
        }

        public boolean isPriority() {
            return this.priority;
        }

        public boolean isSuccess() {
            return this.success;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Throwable getFailure() {
            boolean bl = !this.success;
            Preconditions.checkState(bl);
            return this.failure;
        }

        public static <T> ExecutionResult<T> success(T result) {
            T t;
            ExecutionResult<T> executionResult = new ExecutionResult<T>(t, true, null, true);
            return executionResult;
        }

        public static <T> ExecutionResult<T> error(Throwable error) {
            return ExecutionResult.error(error, false);
        }

        /*
         * WARNING - void declaration
         */
        public static <T> ExecutionResult<T> error(Throwable error, boolean priorityFailure) {
            void var1_1;
            Throwable throwable;
            ExecutionResult<Object> executionResult = new ExecutionResult<Object>(null, false, throwable, (boolean)var1_1);
            return executionResult;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("priority", this.priority).add("success", this.success).add("result", this.result).add("failure", this.failure).toString();
        }
    }
}

