/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.Locale;

public final class PerformException
extends RuntimeException
implements EspressoException {
    private static final String MESSAGE_FORMAT = "Error performing '%s' on view '%s'.";
    private final String actionDescription;
    private final String viewDescription;

    /*
     * WARNING - void declaration
     */
    private PerformException(Builder builder) {
        void var1_1;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)var1_1).actionDescription, ((Builder)var1_1).viewDescription};
        super(String.format(locale, MESSAGE_FORMAT, objectArray), ((Builder)var1_1).cause);
        this.actionDescription = Preconditions.checkNotNull(((Builder)var1_1).actionDescription);
        this.viewDescription = Preconditions.checkNotNull(((Builder)var1_1).viewDescription);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-PerformException.txt");
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public String getViewDescription() {
        return this.viewDescription;
    }

    public static class Builder {
        private String actionDescription;
        private String viewDescription;
        private Throwable cause;

        /*
         * WARNING - void declaration
         */
        public Builder from(PerformException instance) {
            void var1_1;
            this.actionDescription = var1_1.getActionDescription();
            this.viewDescription = var1_1.getViewDescription();
            this.cause = var1_1.getCause();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withActionDescription(String actionDescription) {
            void var1_1;
            this.actionDescription = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewDescription(String viewDescription) {
            void var1_1;
            this.viewDescription = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withCause(Throwable cause) {
            void var1_1;
            this.cause = var1_1;
            return this;
        }

        public PerformException build() {
            PerformException performException = new PerformException(this);
            return performException;
        }
    }
}

