/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.SearchView;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TypeTextAction
implements ViewAction {
    private static final String TAG = TypeTextAction.class.getSimpleName();
    @RemoteMsgField(order=0)
    final String stringToBeTyped;
    @RemoteMsgField(order=1)
    final boolean tapToFocus;
    final GeneralClickAction clickAction;

    /*
     * WARNING - void declaration
     */
    public TypeTextAction(String stringToBeTyped) {
        this((String)var1_1, true, TypeTextAction.defaultClickAction());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @RemoteMsgConstructor
    public TypeTextAction(String stringToBeTyped, boolean tapToFocus) {
        this((String)var1_1, (boolean)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TypeTextAction(String stringToBeTyped, boolean tapToFocus, GeneralClickAction clickAction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(var1_1);
        this.stringToBeTyped = var1_1;
        this.tapToFocus = var2_2;
        this.clickAction = var3_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Matcher<View> getConstraints() {
        Matcher matcher = new Matcher[]{ViewMatchers.isDisplayed()};
        matcher = Matchers.allOf((Matcher[])matcher);
        TypeTextAction typeTextAction = !typeTextAction.tapToFocus ? Matchers.allOf((Matcher)matcher, ViewMatchers.hasFocus()) : matcher;
        if (Build.VERSION.SDK_INT < 11) {
            return Matchers.allOf((Matcher)typeTextAction, ViewMatchers.supportsInputMethods());
        }
        return Matchers.allOf((Matcher)typeTextAction, (Matcher)Matchers.anyOf(ViewMatchers.supportsInputMethods(), ViewMatchers.isAssignableFrom(SearchView.class)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController uiController, View view) {
        Object object;
        void var2_3;
        Object object2;
        if (this.stringToBeTyped.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return;
        }
        if (this.tapToFocus) {
            if (this.clickAction == null) {
                TypeTextAction.defaultClickAction().perform((UiController)object2, (View)var2_3);
            } else {
                this.clickAction.perform((UiController)object2, (View)var2_3);
            }
            object2.loopMainThreadUntilIdle();
        }
        try {
            boolean bl = object2.injectString(this.stringToBeTyped);
            if (bl) {
                return;
            }
            Object object3 = TAG;
            object2 = "Failed to type text: ";
            object = String.valueOf(this.stringToBeTyped);
            int n = ((String)object).length();
            object2 = n != 0 ? ((String)object2).concat((String)object) : (object = new String((String)object2));
            Log.e((String)object3, (String)object2);
            object2 = new PerformException.Builder();
            object3 = ((PerformException.Builder)object2).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)var2_3));
            object2 = "Failed to type text: ";
            String string = String.valueOf(this.stringToBeTyped);
            int n2 = string.length();
            if (n2 != 0) {
                object2 = ((String)object2).concat(string);
            } else {
                string = new String((String)object2);
                object2 = string;
            }
            object = new RuntimeException((String)object2);
            throw ((PerformException.Builder)object3).withCause((Throwable)object).build();
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            object = TAG;
            object2 = String.valueOf(this.stringToBeTyped);
            String string = "Failed to type text: ";
            object2 = ((String)object2).length() != 0 ? string.concat((String)object2) : new String(string);
            Log.e((String)object, (String)object2);
            object2 = new PerformException.Builder();
            throw ((PerformException.Builder)object2).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)var2_3)).withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.stringToBeTyped};
        return String.format(locale, "type text(%s)", objectArray);
    }

    private static GeneralClickAction defaultClickAction() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return generalClickAction;
    }
}

