/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Iterator;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class PositionAssertions {
    private static final String TAG = "PositionAssertions";

    private PositionAssertions() {
    }

    public static ViewAssertion isCompletelyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_LEFT_OF);
    }

    public static ViewAssertion isCompletelyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_RIGHT_OF);
    }

    @Deprecated
    public static ViewAssertion isLeftOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyLeftOf(matcher);
    }

    @Deprecated
    public static ViewAssertion isRightOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyRightOf(matcher);
    }

    public static ViewAssertion isPartiallyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_LEFT_OF);
    }

    public static ViewAssertion isPartiallyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_RIGHT_OF);
    }

    public static ViewAssertion isLeftAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.LEFT_ALIGNED);
    }

    public static ViewAssertion isRightAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.RIGHT_ALIGNED);
    }

    public static ViewAssertion isCompletelyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_ABOVE);
    }

    public static ViewAssertion isCompletelyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_BELOW);
    }

    public static ViewAssertion isPartiallyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_ABOVE);
    }

    public static ViewAssertion isPartiallyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_BELOW);
    }

    @Deprecated
    public static ViewAssertion isAbove(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyAbove(matcher);
    }

    @Deprecated
    public static ViewAssertion isBelow(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyBelow(matcher);
    }

    public static ViewAssertion isBottomAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.BOTTOM_ALIGNED);
    }

    public static ViewAssertion isTopAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.TOP_ALIGNED);
    }

    /*
     * WARNING - void declaration
     */
    static ViewAssertion relativePositionOf(Matcher<View> viewMatcher, Position position) {
        Matcher<View> matcher;
        void var1_1;
        Preconditions.checkNotNull(viewMatcher);
        ViewAssertion viewAssertion = new ViewAssertion((Position)var1_1, matcher){
            final /* synthetic */ Position val$position;
            final /* synthetic */ Matcher val$viewMatcher;
            {
                this.val$position = position;
                this.val$viewMatcher = matcher;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void check(View foundView, NoMatchingViewException noViewException) {
                Object[] objectArray;
                void var2_2;
                StringDescription stringDescription = new StringDescription();
                if (var2_2 != null) {
                    Locale locale = Locale.ROOT;
                    objectArray = new Object[]{var2_2.getViewMatcherDescription()};
                    stringDescription.appendText(String.format(locale, "' check could not be performed because view '%s' was not found.\n", objectArray));
                    Log.e((String)PositionAssertions.TAG, (String)stringDescription.toString());
                    throw var2_2;
                }
                stringDescription.appendText("View:").appendText(HumanReadables.describe((View)objectArray)).appendText(" is not ").appendText(locale.val$position.toString()).appendText(" view ").appendText(locale.val$viewMatcher.toString());
                ViewMatchers.assertThat(stringDescription.toString(), PositionAssertions.isRelativePosition((View)objectArray, PositionAssertions.findView((Matcher<View>)locale.val$viewMatcher, (View)PositionAssertions.getTopViewGroup((View)objectArray)), locale.val$position), Matchers.is((Object)true));
            }
        };
        return viewAssertion;
    }

    /*
     * WARNING - void declaration
     */
    static View findView(Matcher<View> toView, View root) {
        Matcher<View> matcher;
        void var1_1;
        Preconditions.checkNotNull(toView);
        Preconditions.checkNotNull(var1_1);
        Predicate<View> predicate = new Predicate<View>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean apply(View input) {
                void var1_1;
                return matcher.matches((Object)var1_1);
            }
        };
        Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal((View)var1_1), predicate).iterator();
        predicate = null;
        while (iterator.hasNext()) {
            if (predicate != null) {
                AmbiguousViewMatcherException.Builder builder = new AmbiguousViewMatcherException.Builder();
                throw builder.withRootView((View)var1_1).withViewMatcher(matcher).withView1((View)predicate).withView2(iterator.next()).withOtherAmbiguousViews(Iterators.toArray(iterator, View.class)).build();
            }
            predicate = iterator.next();
        }
        if (predicate == null) {
            predicate = new Predicate<View>();
            throw ((NoMatchingViewException.Builder)((Object)predicate)).withViewMatcher(matcher).withRootView((View)var1_1).build();
        }
        return predicate;
    }

    private static ViewGroup getTopViewGroup(View view) {
        ViewGroup viewGroup = null;
        for (View view2 = view.getParent(); view2 != null; view2 = view2.getParent()) {
            if (!(view2 instanceof ViewGroup)) continue;
            viewGroup = (ViewGroup)view2;
        }
        return viewGroup;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isRelativePosition(View view1, View view2, Position position) {
        void var2_14;
        void var1_13;
        View view;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        view.getLocationOnScreen(nArray);
        var1_13.getLocationOnScreen(nArray2);
        switch (3.$SwitchMap$androidx$test$espresso$assertion$PositionAssertions$Position[var2_14.ordinal()]) {
            case 12: {
                if (nArray[1] + view.getHeight() != nArray2[1] + var1_13.getHeight()) return false;
                return true;
            }
            case 11: {
                if (nArray[1] != nArray2[1]) return false;
                return true;
            }
            case 10: {
                if (nArray[0] + view.getWidth() != nArray2[0] + var1_13.getWidth()) return false;
                return true;
            }
            case 9: {
                if (nArray[0] != nArray2[0]) return false;
                return true;
            }
            case 8: {
                if (nArray2[1] >= nArray[1]) return false;
                if (nArray[1] >= nArray2[1] + var1_13.getHeight()) return false;
                return true;
            }
            case 7: {
                if (nArray[1] >= nArray2[1]) return false;
                if (nArray2[1] >= nArray[1] + view.getHeight()) return false;
                return true;
            }
            case 6: {
                if (nArray2[0] >= nArray[0]) return false;
                if (nArray[0] >= nArray2[0] + var1_13.getWidth()) return false;
                return true;
            }
            case 5: {
                if (nArray[0] >= nArray2[0]) return false;
                if (nArray2[0] >= nArray[0] + view.getWidth()) return false;
                return true;
            }
            case 4: {
                if (nArray2[1] + var1_13.getHeight() > nArray[1]) return false;
                return true;
            }
            case 3: {
                if (nArray[1] + view.getHeight() > nArray2[1]) return false;
                return true;
            }
            case 2: {
                if (nArray2[0] + var1_13.getWidth() > nArray[0]) return false;
                return true;
            }
            case 1: {
                if (nArray[0] + view.getWidth() > nArray2[0]) return false;
                return true;
            }
        }
        return false;
    }

    static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position COMPLETELY_LEFT_OF;
        public static final /* enum */ Position COMPLETELY_RIGHT_OF;
        public static final /* enum */ Position COMPLETELY_ABOVE;
        public static final /* enum */ Position COMPLETELY_BELOW;
        public static final /* enum */ Position PARTIALLY_LEFT_OF;
        public static final /* enum */ Position PARTIALLY_RIGHT_OF;
        public static final /* enum */ Position PARTIALLY_ABOVE;
        public static final /* enum */ Position PARTIALLY_BELOW;
        public static final /* enum */ Position LEFT_ALIGNED;
        public static final /* enum */ Position RIGHT_ALIGNED;
        public static final /* enum */ Position TOP_ALIGNED;
        public static final /* enum */ Position BOTTOM_ALIGNED;
        private final String positionValue;
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String name) {
            String string;
            return Enum.valueOf(Position.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private Position(String value) {
            void var3_3;
            this.positionValue = var3_3;
        }

        public String toString() {
            return this.positionValue;
        }

        static {
            Position position;
            COMPLETELY_LEFT_OF = position = new Position("completely left of");
            COMPLETELY_RIGHT_OF = position = new Position("completely right of");
            COMPLETELY_ABOVE = position = new Position("completely above");
            COMPLETELY_BELOW = position = new Position("completely below");
            PARTIALLY_LEFT_OF = position = new Position("partially left of");
            PARTIALLY_RIGHT_OF = position = new Position("partially right of");
            PARTIALLY_ABOVE = position = new Position("partially above");
            PARTIALLY_BELOW = position = new Position("partially below");
            LEFT_ALIGNED = position = new Position("aligned left with");
            RIGHT_ALIGNED = position = new Position("aligned right with");
            TOP_ALIGNED = position = new Position("aligned top with");
            BOTTOM_ALIGNED = position = new Position("aligned bottom with");
            $VALUES = positionArray = new Position[]{Position.COMPLETELY_LEFT_OF, Position.COMPLETELY_RIGHT_OF, Position.COMPLETELY_ABOVE, Position.COMPLETELY_BELOW, Position.PARTIALLY_LEFT_OF, Position.PARTIALLY_RIGHT_OF, Position.PARTIALLY_ABOVE, Position.PARTIALLY_BELOW, Position.LEFT_ALIGNED, Position.RIGHT_ALIGNED, Position.TOP_ALIGNED, Position.BOTTOM_ALIGNED};
        }
    }
}

