/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.Interrogator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

class LooperIdlingResourceInterrogationHandler
implements Interrogator.InterrogationHandler<Void>,
IdlingResource {
    private static final ConcurrentHashMap<String, LooperIdlingResourceInterrogationHandler> insts;
    private final Interrogator.QueueInterrogationHandler<Boolean> queueHasNewTasks;
    private final String name;
    private volatile boolean started;
    private volatile MessageQueue queue;
    private volatile boolean idle;
    private volatile IdlingResource.ResourceCallback cb;

    /*
     * WARNING - void declaration
     */
    private LooperIdlingResourceInterrogationHandler(String name) {
        void var1_1;
        Interrogator.QueueInterrogationHandler<Boolean> queueInterrogationHandler;
        this.queueHasNewTasks = queueInterrogationHandler = new Interrogator.QueueInterrogationHandler<Boolean>(this){
            private Boolean hasTasks = Boolean.FALSE;

            @Override
            public Boolean get() {
                return this.hasTasks;
            }

            @Override
            public boolean queueEmpty() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueLong() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueSoon() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }

            @Override
            public boolean barrierUp() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }
        };
        this.started = false;
        this.queue = null;
        this.idle = true;
        this.cb = null;
        this.name = var1_1;
    }

    static LooperIdlingResourceInterrogationHandler forLooper(Looper l) {
        Object object;
        Object object2 = Locale.ROOT;
        Object object3 = new Object[]{object.getThread().getId(), object.getThread().getName()};
        object2 = String.format((Locale)object2, "LooperIdlingResource-%s-%s", object3);
        object3 = new LooperIdlingResourceInterrogationHandler((String)object2);
        if ((object2 = insts.putIfAbsent((String)object2, (LooperIdlingResourceInterrogationHandler)object3)) != null) {
            return object2;
        }
        object2 = new Handler(object);
        object = new Runnable(){

            @Override
            public void run() {
                LooperIdlingResourceInterrogationHandler.access$002(LooperIdlingResourceInterrogationHandler.this, Looper.myQueue());
                LooperIdlingResourceInterrogationHandler.access$102(LooperIdlingResourceInterrogationHandler.this, true);
                Interrogator.loopAndInterrogate(LooperIdlingResourceInterrogationHandler.this);
            }
        };
        object2.post((Runnable)object);
        return object3;
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public void quitting() {
        this.transitionToIdle();
    }

    @Override
    public boolean queueEmpty() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean taskDueLong() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean beforeTaskDispatch() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean taskDueSoon() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean barrierUp() {
        this.idle = false;
        return true;
    }

    @Override
    public Void get() {
        return null;
    }

    public boolean isIdleNow() {
        if (!this.started) {
            return false;
        }
        if (this.idle) {
            return Boolean.FALSE.equals(Interrogator.peekAtQueueState(this.queue, this.queueHasNewTasks));
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback cb) {
        void var1_1;
        this.cb = var1_1;
    }

    private void transitionToIdle() {
        this.idle = true;
        if (this.cb != null) {
            this.cb.onTransitionToIdle();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MessageQueue access$002(LooperIdlingResourceInterrogationHandler x0, MessageQueue x1) {
        void var1_1;
        x0.queue = var1_1;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(LooperIdlingResourceInterrogationHandler x0, boolean x1) {
        void var1_1;
        x0.started = var1_1;
        return (boolean)var1_1;
    }

    static {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        insts = concurrentHashMap;
    }
}

