/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingUiController;
import androidx.test.espresso.base.Interrogator;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.NoopIdleNotificationCallbackIdleNotifierProvider;
import androidx.test.espresso.base.NoopRunnableIdleNotifier;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.inject.Provider;

final class UiControllerImpl
implements InterruptableUiController,
Handler.Callback,
IdlingUiController {
    private static final String TAG;
    private static final Callable<Void> NO_OP;
    private final EventInjector eventInjector;
    private final BitSet conditionSet;
    private final ExecutorService keyEventExecutor;
    private final Looper mainLooper;
    private final IdlingResourceRegistry idlingResourceRegistry;
    private Handler controllerHandler;
    private MainThreadInterrogation interrogation;
    private int generation;
    private IdleNotifier<Runnable> asyncIdle;
    private IdleNotifier<Runnable> compatIdle;
    private Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdleProvider;

    /*
     * WARNING - void declaration
     */
    UiControllerImpl(EventInjector eventInjector, @SdkAsyncTask IdleNotifier<Runnable> asyncIdle, @CompatAsyncTask IdleNotifier<Runnable> compatIdle, Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdle, Looper mainLooper, IdlingResourceRegistry idlingResourceRegistry) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        this.keyEventExecutor = Executors.newSingleThreadExecutor(threadFactoryBuilder.setNameFormat("Espresso Key Event #%d").build());
        this.generation = 0;
        this.eventInjector = (EventInjector)Preconditions.checkNotNull(var1_1);
        this.asyncIdle = (IdleNotifier)Preconditions.checkNotNull(var2_2);
        this.compatIdle = (IdleNotifier)Preconditions.checkNotNull(var3_3);
        this.conditionSet = IdleCondition.createConditionSet();
        this.dynamicIdleProvider = (Provider)Preconditions.checkNotNull(var4_4);
        this.mainLooper = (Looper)Preconditions.checkNotNull(var5_5);
        this.idlingResourceRegistry = (IdlingResourceRegistry)Preconditions.checkNotNull(var6_6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectKeyEvent(KeyEvent event) throws InjectEventSecurityException {
        ExecutionException executionException2;
        RuntimeException runtimeException;
        block3: {
            Preconditions.checkNotNull(event);
            boolean bl = Looper.myLooper() == this.mainLooper;
            Preconditions.checkState(bl, "Expecting to be on main thread!");
            this.initialize();
            this.loopMainThreadUntilIdle();
            Callable<Boolean> callable = new Callable<Boolean>(this, (KeyEvent)runtimeException){
                final /* synthetic */ KeyEvent val$event;
                final /* synthetic */ UiControllerImpl this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$event = keyEvent;
                }

                @Override
                public Boolean call() throws Exception {
                    return this.this$0.eventInjector.injectKeyEvent(this.val$event);
                }
            };
            SignalingTask<Boolean> signalingTask = new SignalingTask<Boolean>(callable, IdleCondition.KEY_INJECT_HAS_COMPLETED, this.generation);
            this.keyEventExecutor.submit(signalingTask);
            this.loopUntil(IdleCondition.KEY_INJECT_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
            try {
                Preconditions.checkState(signalingTask.isDone(), "Key injection was signaled - but it wasnt done.");
                return (Boolean)signalingTask.get();
            }
            catch (InterruptedException interruptedException) {
                runtimeException = new RuntimeException("impossible.", interruptedException);
                throw runtimeException;
            }
            catch (ExecutionException executionException2) {
                if (!(executionException2.getCause() instanceof InjectEventSecurityException)) break block3;
                throw (InjectEventSecurityException)((Object)executionException2.getCause());
            }
        }
        runtimeException = new RuntimeException(executionException2.getCause());
        throw runtimeException;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEvent(MotionEvent event) throws InjectEventSecurityException {
        void var1_1;
        Preconditions.checkNotNull(event);
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        this.initialize();
        Callable<Boolean> callable = new Callable<Boolean>(this, (MotionEvent)var1_1){
            final /* synthetic */ MotionEvent val$event;
            final /* synthetic */ UiControllerImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$event = motionEvent;
            }

            @Override
            public Boolean call() throws Exception {
                return this.this$0.eventInjector.injectMotionEvent(this.val$event);
            }
        };
        Object object = new SignalingTask(callable, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        this.keyEventExecutor.submit((Runnable)object);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(((FutureTask)object).isDone(), "Motion event injection was signaled - but it wasnt done.");
            boolean bl2 = (Boolean)((FutureTask)object).get();
            this.loopMainThreadUntilIdle();
            return bl2;
        }
        catch (ExecutionException executionException) {
            try {
                boolean bl3 = executionException.getCause() instanceof InjectEventSecurityException;
                if (bl3) {
                    throw (InjectEventSecurityException)((Object)executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    object = new RuntimeException(interruptedException);
                    throw object;
                }
            }
            catch (Throwable throwable2) {
                this.loopMainThreadUntilIdle();
                throw throwable2;
            }
        }
        {
            Throwable throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            Throwables.throwIfUnchecked(throwable);
            throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            callable = new Callable<Boolean>(throwable);
            throw callable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEventSequence(Iterable<MotionEvent> events) throws InjectEventSecurityException {
        Object object;
        Preconditions.checkNotNull(events);
        boolean bl = !Iterables.isEmpty(object);
        Preconditions.checkState(bl, "Expecting non-empty events to inject");
        bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        this.initialize();
        Object object2 = object.iterator();
        object = Iterables.getFirst(object, null);
        object = (MotionEvent)object;
        long l = object.getEventTime();
        long l2 = SystemClock.uptimeMillis();
        Callable<Boolean> callable = new Callable<Boolean>(this, object2, l2 - l){
            final /* synthetic */ Iterator val$mei;
            final /* synthetic */ long val$shift;
            final /* synthetic */ UiControllerImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$mei = iterator;
                this.val$shift = l;
            }

            @Override
            public Boolean call() throws Exception {
                boolean bl = true;
                while (this.val$mei.hasNext()) {
                    MotionEvent motionEvent = (MotionEvent)this.val$mei.next();
                    long l = motionEvent.getEventTime() + this.val$shift - SystemClock.uptimeMillis();
                    if (l > 10L) {
                        SystemClock.sleep((long)l);
                    }
                    if (this.val$mei.hasNext()) {
                        bl &= this.this$0.eventInjector.injectMotionEventAsync(motionEvent);
                        continue;
                    }
                    bl &= this.this$0.eventInjector.injectMotionEvent(motionEvent);
                }
                return bl;
            }
        };
        object = new SignalingTask(callable, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        this.keyEventExecutor.submit((Runnable)object);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(((FutureTask)object).isDone(), "MotionEvents injection was signaled - but it wasnt done.");
            boolean bl2 = (Boolean)((FutureTask)object).get();
            this.loopMainThreadUntilIdle();
            return bl2;
        }
        catch (ExecutionException executionException) {
            try {
                boolean bl3 = executionException.getCause() instanceof InjectEventSecurityException;
                if (bl3) {
                    throw (InjectEventSecurityException)((Object)executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    object2 = new RuntimeException(interruptedException);
                    throw object2;
                }
            }
            catch (Throwable throwable2) {
                this.loopMainThreadUntilIdle();
                throw throwable2;
            }
        }
        {
            Throwable throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            Throwables.throwIfUnchecked(throwable);
            throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            callable = new Callable<Boolean>(throwable);
            throw callable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean injectString(String str) throws InjectEventSecurityException {
        Object object;
        void var1_2;
        Preconditions.checkNotNull(str);
        boolean bl = Looper.myLooper() == ((UiControllerImpl)object).mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        ((UiControllerImpl)object).initialize();
        if (var1_2.isEmpty()) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return true;
        }
        KeyEvent[] keyEventArray = UiControllerImpl.getKeyCharacterMap().getEvents(var1_2.toCharArray());
        if (keyEventArray == null) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{var1_2};
            object = new RuntimeException(String.format(locale, "Failed to get key events for string %s (i.e. current IME does not understand how to translate the string into key events). As a workaround, you can use replaceText action to set the text directly in the EditText field.", objectArray));
            throw object;
        }
        String string = TAG;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{var1_2};
        Log.d((String)string, (String)String.format(locale, "Injecting string: \"%s\"", objectArray));
        int n = keyEventArray.length;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            locale = keyEventArray[n2];
            Locale locale2 = Locale.ROOT;
            objectArray = new Object[]{locale.getKeyCode(), locale.getUnicodeChar()};
            Preconditions.checkNotNull(locale, String.format(locale2, "Failed to get event for character (%c) with key code (%s)", objectArray));
            bl2 = false;
            for (int i = 0; !bl2 && i < 4; ++i) {
                locale = KeyEvent.changeTimeRepeat((KeyEvent)locale, (long)SystemClock.uptimeMillis(), (int)0);
                bl2 = ((UiControllerImpl)object).injectKeyEvent((KeyEvent)locale);
            }
            if (!bl2) {
                object = TAG;
                Locale locale3 = Locale.ROOT;
                Object[] objectArray2 = new Object[]{locale.getUnicodeChar(), locale.getKeyCode()};
                Log.e((String)object, (String)String.format(locale3, "Failed to inject event for character (%c) with key code (%s)", objectArray2));
                return bl2;
            }
            ++n2;
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"InlinedApi"})
    public static KeyCharacterMap getKeyCharacterMap() {
        if (Build.VERSION.SDK_INT >= 11) return KeyCharacterMap.load((int)-1);
        return KeyCharacterMap.load((int)0);
    }

    @Override
    public IdlingResourceRegistry getIdlingResourceRegistry() {
        return this.idlingResourceRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loopMainThreadUntilIdle() {
        this.initialize();
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        Object object = (IdleNotifier)this.dynamicIdleProvider.get();
        while (true) {
            Object object2;
            Object object3;
            Object object4 = EnumSet.noneOf(IdleCondition.class);
            if (!this.asyncIdle.isIdleNow()) {
                object3 = this.asyncIdle;
                object2 = new SignalingTask(NO_OP, IdleCondition.ASYNC_TASKS_HAVE_IDLED, this.generation);
                object3.registerNotificationCallback(object2);
                ((AbstractCollection)object4).add(IdleCondition.ASYNC_TASKS_HAVE_IDLED);
            }
            if (!this.compatIdle.isIdleNow()) {
                object3 = this.compatIdle;
                object2 = new SignalingTask(NO_OP, IdleCondition.COMPAT_TASKS_HAVE_IDLED, this.generation);
                object3.registerNotificationCallback(object2);
                ((AbstractCollection)object4).add(IdleCondition.COMPAT_TASKS_HAVE_IDLED);
            }
            if (!object.isIdleNow()) {
                object3 = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
                object2 = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
                SignalingTask<Void> signalingTask = new SignalingTask<Void>(NO_OP, IdleCondition.DYNAMIC_TASKS_HAVE_IDLED, this.generation);
                IdlingResourceRegistry.IdleNotificationCallback idleNotificationCallback = new IdlingResourceRegistry.IdleNotificationCallback(this, (IdlingPolicy)object3, (IdlingPolicy)object2, signalingTask){
                    final /* synthetic */ IdlingPolicy val$warning;
                    final /* synthetic */ IdlingPolicy val$error;
                    final /* synthetic */ SignalingTask val$idleSignal;
                    final /* synthetic */ UiControllerImpl this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$warning = idlingPolicy;
                        this.val$error = idlingPolicy2;
                        this.val$idleSignal = signalingTask;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void resourcesStillBusyWarning(List<String> busyResourceNames) {
                        void var1_1;
                        this.val$warning.handleTimeout((List<String>)var1_1, "IdlingResources are still busy!");
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void resourcesHaveTimedOut(List<String> busyResourceNames) {
                        void var1_1;
                        this.val$error.handleTimeout((List<String>)var1_1, "IdlingResources have timed out!");
                        this.this$0.controllerHandler.post((Runnable)this.val$idleSignal);
                    }

                    @Override
                    public void allResourcesIdle() {
                        this.this$0.controllerHandler.post((Runnable)this.val$idleSignal);
                    }
                };
                object.registerNotificationCallback(idleNotificationCallback);
                ((AbstractCollection)object4).add(IdleCondition.DYNAMIC_TASKS_HAVE_IDLED);
            }
            try {
                object4 = this.loopUntil((EnumSet<IdleCondition>)object4, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)object);
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                object4.cancelCallback();
                if (this.asyncIdle.isIdleNow()) {
                    if (this.compatIdle.isIdleNow()) {
                        if (object4.isIdleNow()) {
                            return;
                        }
                        object = object4;
                        continue;
                    }
                    object = object4;
                    continue;
                }
                object = object4;
            }
            catch (Throwable throwable) {
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                object.cancelCallback();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void loopMainThreadForAtLeast(long millisDelay) {
        void var1_1;
        this.initialize();
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        bl = !IdleCondition.DELAY_HAS_PAST.isSignaled(this.conditionSet);
        Preconditions.checkState(bl, "recursion detected!");
        bl = var1_1 > 0L;
        Preconditions.checkArgument(bl);
        Handler handler = this.controllerHandler;
        SignalingTask<Void> signalingTask = new SignalingTask<Void>(NO_OP, IdleCondition.DELAY_HAS_PAST, this.generation);
        handler.postAtTime(signalingTask, (Object)this.generation, SystemClock.uptimeMillis() + var1_1);
        this.loopUntil(IdleCondition.DELAY_HAS_PAST, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        this.loopMainThreadUntilIdle();
    }

    public boolean handleMessage(Message msg) {
        if (!IdleCondition.handleMessage(msg, ((UiControllerImpl)((Object)string2)).conditionSet, ((UiControllerImpl)((Object)string2)).generation)) {
            String string;
            String string2 = TAG;
            string = String.valueOf(string);
            String string3 = String.valueOf(string);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            Log.i((String)string2, (String)stringBuilder.append("Unknown message type: ").append(string).toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void loopUntil(IdleCondition condition, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> dynamicIdle) {
        void var2_2;
        void var1_1;
        this.loopUntil(EnumSet.of(var1_1), (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)var2_2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> loopUntil(EnumSet<IdleCondition> conditions, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> dynamicIdle) {
        var3_4 = IdlingPolicies.getMasterIdlingPolicy();
        var4_5 = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
        try {
            var5_8 = SystemClock.uptimeMillis();
            var7_9 = var3_4.getIdleTimeoutUnit().toMillis(var3_4.getIdleTimeout());
            var9_10 = new MainThreadInterrogation((EnumSet<IdleCondition>)var1_1, this.conditionSet, var5_8 += var7_9);
            this.interrogation = var9_10;
            var9_10 = this.interrogation;
            var9_10 = Interrogator.loopAndInterrogate(var9_10);
            var10_11 /* !! */  = InterrogationStatus.COMPLETED;
            if (var10_11 /* !! */  == var9_10) {
                ++this.generation;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var2_3) {
            ++this.generation;
            var1_1 = var1_1.iterator();
            while (true) {
                if (!var1_1.hasNext()) {
                    this.interrogation = null;
                    throw var2_3;
                }
                ((IdleCondition)var1_1.next()).reset(this.conditionSet);
            }
        }
        var1_1 = var1_1.iterator();
        while (true) {
            if (!var1_1.hasNext()) {
                this.interrogation = null;
                return var2_2;
            }
            ((IdleCondition)var1_1.next()).reset(this.conditionSet);
        }
lbl-1000:
        // 1 sources

        {
            var10_11 /* !! */  = InterrogationStatus.INTERRUPTED;
            if (var10_11 /* !! */  != var9_10) ** GOTO lbl37
        }
        {
            Log.w((String)UiControllerImpl.TAG, (String)"Espresso interrogation of the main thread is interrupted");
            var2_2 = new RuntimeException("Espresso interrogation of the main thread is interrupted");
            throw var2_2;
lbl37:
            // 1 sources

            var9_10 = Lists.newArrayList();
            var10_11 /* !! */  = var1_1.iterator();
            block12: while (var11_14 = var10_11 /* !! */ .hasNext()) {
                var11_15 = (IdleCondition)var10_11 /* !! */ .next();
                var12_23 = var11_15.isSignaled(this.conditionSet);
                if (var12_23) continue;
                var9_10.add(var11_15.name());
                switch (7.$SwitchMap$androidx$test$espresso$base$UiControllerImpl$IdleCondition[var11_15.ordinal()]) {
                    default: {
                        continue block12;
                    }
                    case 3: {
                        var11_16 = var4_5.getDisableOnTimeout();
                        if (!var11_16 && ((var11_16 = var3_4.getTimeoutIfDebuggerAttached()) || !(var11_16 = Debug.isDebuggerConnected()))) continue block12;
                        var2_2.cancelCallback();
                        var2_2 = new NoopIdleNotificationCallbackIdleNotifierProvider();
                        this.dynamicIdleProvider = var2_2;
                        var2_2 = (IdleNotifier)this.dynamicIdleProvider.get();
                        continue block12;
                    }
                    case 2: {
                        var11_17 = var3_4.getDisableOnTimeout();
                        if (!var11_17 && ((var11_17 = var3_4.getTimeoutIfDebuggerAttached()) || !(var11_17 = Debug.isDebuggerConnected()))) continue block12;
                        this.compatIdle.cancelCallback();
                        this.compatIdle = var11_18 = new NoopRunnableIdleNotifier();
                        continue block12;
                    }
                    case 1: 
                }
                var11_19 = var3_4.getDisableOnTimeout();
                if (!var11_19 && ((var11_19 = var3_4.getTimeoutIfDebuggerAttached()) || !(var11_19 = Debug.isDebuggerConnected()))) continue;
                this.asyncIdle.cancelCallback();
                this.asyncIdle = var11_20 = new NoopRunnableIdleNotifier();
            }
            var4_6 = var9_10.isEmpty();
            if (!var4_6) ** GOTO lbl75
            var4_5 = this.interrogation.getMessage();
            var10_12 = String.valueOf(var4_5).length();
        }
        {
            var11_21 = new StringBuilder(var10_12 += 37);
            var9_10.add(var11_21.append("MAIN_LOOPER_HAS_IDLED(last message: ").append((String)var4_5).append(")").toString());
lbl75:
            // 2 sources

            var4_7 = Locale.ROOT;
            var10_13 = "Looped for %s iterations over %s %s.";
            var11_22 = new Object[]{MainThreadInterrogation.access$300(this.interrogation), var3_4.getIdleTimeout(), var3_4.getIdleTimeoutUnit().name()};
            var3_4.handleTimeout((List<String>)var9_10, String.format(var4_7, var10_13, var11_22));
            ++this.generation;
        }
        var1_1 = var1_1.iterator();
        while (true) {
            if (!var1_1.hasNext()) {
                this.interrogation = null;
                return var2_2;
            }
            ((IdleCondition)var1_1.next()).reset(this.conditionSet);
        }
    }

    @Override
    public void interruptEspressoTasks() {
        this.initialize();
        Handler handler = this.controllerHandler;
        Runnable runnable = new Runnable(this){
            final /* synthetic */ UiControllerImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                if (this.this$0.interrogation != null) {
                    this.this$0.interrogation.interruptInterrogation();
                    this.this$0.controllerHandler.removeCallbacksAndMessages((Object)this.this$0.generation);
                    return;
                }
            }
        };
        handler.post(runnable);
    }

    private void initialize() {
        if (this.controllerHandler == null) {
            Handler handler;
            this.controllerHandler = handler = new Handler((Handler.Callback)this);
            return;
        }
    }

    static {
        Callable<Void> callable;
        TAG = UiControllerImpl.class.getSimpleName();
        NO_OP = callable = new Callable<Void>(){

            @Override
            public Void call() {
                return null;
            }
        };
    }

    private class SignalingTask<T>
    extends FutureTask<T> {
        private final IdleCondition condition;
        private final int myGeneration;

        /*
         * WARNING - void declaration
         */
        public SignalingTask(Callable<T> callable, IdleCondition condition, int myGeneration) {
            void var4_4;
            void var3_3;
            void var2_2;
            super(var2_2);
            this.condition = (IdleCondition)Preconditions.checkNotNull(var3_3);
            this.myGeneration = var4_4;
        }

        @Override
        protected void done() {
            UiControllerImpl.this.controllerHandler.sendMessage(this.condition.createSignal(UiControllerImpl.this.controllerHandler, this.myGeneration));
        }
    }

    private static final class MainThreadInterrogation
    implements Interrogator.InterrogationHandler<InterrogationStatus> {
        private final EnumSet<IdleCondition> conditions;
        private final BitSet conditionSet;
        private final long giveUpAtMs;
        private String lastMessage;
        private InterrogationStatus status = InterrogationStatus.COMPLETED;
        private int execCount = 0;

        /*
         * WARNING - void declaration
         */
        MainThreadInterrogation(EnumSet<IdleCondition> conditions, BitSet conditionSet, long giveUpAtMs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.conditions = var1_1;
            this.conditionSet = var2_2;
            this.giveUpAtMs = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setMessage(Message m) {
            try {
                void var1_1;
                this.lastMessage = var1_1.toString();
                return;
            }
            catch (NullPointerException nullPointerException) {
                String string = String.valueOf(nullPointerException);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 32);
                this.lastMessage = stringBuilder.append("NPE calling message toString(): ").append(string).toString();
                return;
            }
        }

        @Override
        public String getMessage() {
            return this.lastMessage;
        }

        @Override
        public void quitting() {
        }

        @Override
        public boolean barrierUp() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean queueEmpty() {
            return !this.conditionsMet();
        }

        @Override
        public boolean taskDueSoon() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean taskDueLong() {
            return !this.conditionsMet();
        }

        @Override
        public boolean beforeTaskDispatch() {
            ++this.execCount;
            return this.continueOrTimeout();
        }

        private boolean continueOrTimeout() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return false;
            }
            if (SystemClock.uptimeMillis() >= this.giveUpAtMs) {
                this.status = InterrogationStatus.TIMED_OUT;
                return false;
            }
            return true;
        }

        void interruptInterrogation() {
            this.status = InterrogationStatus.INTERRUPTED;
        }

        @Override
        public InterrogationStatus get() {
            return this.status;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean conditionsMet() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return true;
            }
            boolean bl = this.execCount > 0 && this.execCount % 100 == 0;
            Iterator iterator = this.conditions.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                IdleCondition idleCondition = (IdleCondition)((Object)iterator.next());
                if (idleCondition.isSignaled(this.conditionSet)) continue;
                if (!bl) {
                    return false;
                }
                String string = TAG;
                String string2 = idleCondition.name();
                int n = this.execCount;
                String string3 = String.valueOf(string2);
                int n2 = string3.length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 41);
                Log.w((String)string, (String)stringBuilder.append("Waiting for: ").append(string2).append(" for ").append(n).append(" iterations.").toString());
                bl2 = false;
            }
            return bl2;
        }

        static /* synthetic */ int access$300(MainThreadInterrogation x0) {
            return x0.execCount;
        }
    }

    private static final class InterrogationStatus
    extends Enum<InterrogationStatus> {
        public static final /* enum */ InterrogationStatus TIMED_OUT;
        public static final /* enum */ InterrogationStatus COMPLETED;
        public static final /* enum */ InterrogationStatus INTERRUPTED;
        private static final /* synthetic */ InterrogationStatus[] $VALUES;

        public static InterrogationStatus[] values() {
            return (InterrogationStatus[])$VALUES.clone();
        }

        public static InterrogationStatus valueOf(String name) {
            String string;
            return Enum.valueOf(InterrogationStatus.class, string);
        }

        static {
            InterrogationStatus interrogationStatus;
            TIMED_OUT = interrogationStatus = new InterrogationStatus();
            COMPLETED = interrogationStatus = new InterrogationStatus();
            INTERRUPTED = interrogationStatus = new InterrogationStatus();
            $VALUES = interrogationStatusArray = new InterrogationStatus[]{InterrogationStatus.TIMED_OUT, InterrogationStatus.COMPLETED, InterrogationStatus.INTERRUPTED};
        }
    }

    static final class IdleCondition
    extends Enum<IdleCondition> {
        public static final /* enum */ IdleCondition DELAY_HAS_PAST;
        public static final /* enum */ IdleCondition ASYNC_TASKS_HAVE_IDLED;
        public static final /* enum */ IdleCondition COMPAT_TASKS_HAVE_IDLED;
        public static final /* enum */ IdleCondition KEY_INJECT_HAS_COMPLETED;
        public static final /* enum */ IdleCondition MOTION_INJECTION_HAS_COMPLETED;
        public static final /* enum */ IdleCondition DYNAMIC_TASKS_HAVE_IDLED;
        private static final /* synthetic */ IdleCondition[] $VALUES;

        public static IdleCondition[] values() {
            return (IdleCondition[])$VALUES.clone();
        }

        public static IdleCondition valueOf(String name) {
            String string;
            return Enum.valueOf(IdleCondition.class, string);
        }

        public boolean isSignaled(BitSet conditionSet) {
            return conditionSet.get(this.ordinal());
        }

        public void reset(BitSet conditionSet) {
            conditionSet.set(this.ordinal(), false);
        }

        /*
         * WARNING - void declaration
         */
        public Message createSignal(Handler handler, int myGeneration) {
            void var2_2;
            return Message.obtain((Handler)handler, (int)this.ordinal(), (int)var2_2, (int)0, null);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean handleMessage(Message message, BitSet conditionSet, int currentGeneration) {
            String string;
            void var2_3;
            Message message2;
            Object object = IdleCondition.values();
            if (message2.what < 0 || message2.what >= ((IdleCondition[])object).length) {
                return false;
            }
            object = object[message2.what];
            if (message2.arg1 == var2_3) {
                ((IdleCondition)((Object)object)).signal((BitSet)((Object)string));
                return true;
            }
            string = TAG;
            object = String.valueOf(object);
            int n = message2.arg1;
            String string2 = String.valueOf(object);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 90);
            Log.w((String)string, (String)stringBuilder.append("ignoring signal of: ").append((String)object).append(" from previous generation: ").append(n).append(" current generation: ").append((int)var2_3).toString());
            return true;
        }

        public static BitSet createConditionSet() {
            BitSet bitSet = new BitSet(IdleCondition.values().length);
            return bitSet;
        }

        protected void signal(BitSet conditionSet) {
            conditionSet.set(this.ordinal());
        }

        static {
            IdleCondition idleCondition;
            DELAY_HAS_PAST = idleCondition = new IdleCondition();
            ASYNC_TASKS_HAVE_IDLED = idleCondition = new IdleCondition();
            COMPAT_TASKS_HAVE_IDLED = idleCondition = new IdleCondition();
            KEY_INJECT_HAS_COMPLETED = idleCondition = new IdleCondition();
            MOTION_INJECTION_HAS_COMPLETED = idleCondition = new IdleCondition();
            DYNAMIC_TASKS_HAVE_IDLED = idleCondition = new IdleCondition();
            $VALUES = idleConditionArray = new IdleCondition[]{IdleCondition.DELAY_HAS_PAST, IdleCondition.ASYNC_TASKS_HAVE_IDLED, IdleCondition.COMPAT_TASKS_HAVE_IDLED, IdleCondition.KEY_INJECT_HAS_COMPLETED, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, IdleCondition.DYNAMIC_TASKS_HAVE_IDLED};
        }
    }
}

