/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.core.internal.deps.guava.collect.Platform;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final <T> T[] toArray(T[] TArray) {
        Preconditions.checkNotNull(TArray);
        int n = this.size();
        if (TArray.length < n) {
            Object[] objectArray = this.internalArray();
            if (objectArray != null) {
                return Platform.copy(objectArray, this.internalArrayStart(), this.internalArrayEnd(), TArray);
            }
            TArray = ObjectArrays.newArray(TArray, n);
        } else if (TArray.length > n) {
            TArray[n] = null;
        }
        this.copyIntoArray(TArray, 0);
        return TArray;
    }

    Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    int internalArrayEnd() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    @Deprecated
    public final boolean add(E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final void clear() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    int copyIntoArray(Object[] objectArray, int n) {
        throw null;
    }

    Object writeReplace() {
        ImmutableList.SerializedForm serializedForm = new ImmutableList.SerializedForm(this.toArray());
        return serializedForm;
    }

    static abstract class ArrayBasedBuilder<E>
    extends Builder<E> {
        Object[] contents;
        int size;
        boolean forceCopy;

        ArrayBasedBuilder(int n) {
            CollectPreconditions.checkNonnegative(n, "initialCapacity");
            this.contents = new Object[n];
            this.size = 0;
        }

        private void getReadyToExpandTo(int n) {
            if (this.contents.length < n) {
                this.contents = Arrays.copyOf(this.contents, ArrayBasedBuilder.expandedCapacity(this.contents.length, n));
                this.forceCopy = false;
                return;
            }
            if (this.forceCopy) {
                this.contents = (Object[])this.contents.clone();
                this.forceCopy = false;
                return;
            }
        }

        public ArrayBasedBuilder<E> add(E e) {
            Preconditions.checkNotNull(e);
            this.getReadyToExpandTo(this.size + 1);
            Object[] objectArray = this.contents;
            int n = this.size;
            this.size = n + 1;
            objectArray[n] = e;
            return this;
        }

        public Builder<E> add(E ... EArray) {
            this.addAll(EArray, EArray.length);
            return this;
        }

        final void addAll(Object[] objectArray, int n) {
            ObjectArrays.checkElementsNotNull(objectArray, n);
            this.getReadyToExpandTo(this.size + n);
            System.arraycopy(objectArray, 0, this.contents, this.size, n);
            this.size += n;
        }
    }

    public static abstract class Builder<E> {
        static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                AssertionError assertionError = new AssertionError((Object)"cannot store more than MAX_VALUE elements");
                throw assertionError;
            }
            if ((n = n + (n >> 1) + 1) < n2) {
                n = Integer.highestOneBit(n2 + -1);
                n += n;
            }
            if (n < 0) {
                return Integer.MAX_VALUE;
            }
            return n;
        }

        Builder() {
        }
    }
}

