/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ExecutionList {
    private static final Logger log = Logger.getLogger(ExecutionList.class.getName());
    private RunnableExecutorPair runnables;
    private boolean executed;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        synchronized (this) {
            boolean bl = this.executed;
            if (!bl) {
                RunnableExecutorPair runnableExecutorPair;
                this.runnables = runnableExecutorPair = new RunnableExecutorPair(runnable, executor, this.runnables);
                return;
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ExecutionList.executeListener(runnable, executor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        Object object;
        Object object2;
        synchronized (object) {
            boolean bl = ((ExecutionList)object).executed;
            if (bl) {
                return;
            }
            ((ExecutionList)object).executed = true;
            object2 = ((ExecutionList)object).runnables;
            ((ExecutionList)object).runnables = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : this
            object = object2;
            object2 = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        while (object != null) {
            RunnableExecutorPair runnableExecutorPair = ((RunnableExecutorPair)object).next;
            ((RunnableExecutorPair)object).next = object2;
            object2 = object;
            object = runnableExecutorPair;
        }
        object = object2;
        while (object != null) {
            ExecutionList.executeListener(((RunnableExecutorPair)object).runnable, ((RunnableExecutorPair)object).executor);
            object = ((RunnableExecutorPair)object).next;
        }
    }

    private static void executeListener(Runnable object, Executor object2) {
        try {
            object2.execute((Runnable)object);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            object = String.valueOf(object);
            object2 = String.valueOf(object2);
            String string = String.valueOf(object);
            int n = string.length();
            String string2 = String.valueOf(object2);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 57 + n2);
            logger.logp(level, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.ExecutionList", "executeListener", stringBuilder.append("RuntimeException while executing runnable ").append((String)object).append(" with executor ").append((String)object2).toString(), runtimeException);
            return;
        }
    }

    private static final class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;
        RunnableExecutorPair next;

        RunnableExecutorPair(Runnable runnable, Executor executor, RunnableExecutorPair runnableExecutorPair) {
            this.runnable = runnable;
            this.executor = executor;
            this.next = runnableExecutorPair;
        }
    }
}

