/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public abstract class BoundedMatcher<T, S extends T>
extends BaseMatcher<T> {
    private final Class<?> expectedType;
    private final Class<?>[] interfaceTypes;

    /*
     * WARNING - void declaration
     */
    public BoundedMatcher(Class<? extends S> expectedType) {
        void var1_1;
        this.expectedType = (Class)Preconditions.checkNotNull(var1_1);
        this.interfaceTypes = new Class[0];
    }

    /*
     * WARNING - void declaration
     */
    public BoundedMatcher(Class<?> expectedType, Class<?> interfaceType1, Class<?> ... otherInterfaces) {
        void var2_3;
        void var3_5;
        void var1_1;
        this.expectedType = (Class)Preconditions.checkNotNull(var1_1);
        Preconditions.checkNotNull(var3_5);
        this.interfaceTypes = new Class[((void)var3_5).length + 1];
        this.interfaceTypes[0] = (Class)Preconditions.checkNotNull(var2_3);
        Preconditions.checkArgument(var2_3.isInterface());
        int n = ((void)var3_5).length;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            void var5_7 = var3_5[i];
            this.interfaceTypes[n2] = (Class)Preconditions.checkNotNull(var5_7);
            Preconditions.checkArgument(var5_7.isInterface());
            ++n2;
        }
    }

    protected abstract boolean matchesSafely(S var1);

    /*
     * WARNING - void declaration
     */
    public final boolean matches(Object item) {
        void var1_1;
        if (item == null) {
            return false;
        }
        if (this.expectedType.isInstance(var1_1)) {
            Class<?>[] classArray = this.interfaceTypes;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (classArray[i].isInstance(var1_1)) continue;
                return false;
            }
            return this.matchesSafely(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void describeMismatch(Object item, Description description) {
        void var1_2;
        void var2_3;
        if (item == null) {
            var2_3.appendText("item was null");
            return;
        }
        if (!this.expectedType.isInstance(var1_2)) {
            var2_3.appendText("item does not extend ").appendText(this.expectedType.getName());
            return;
        }
        for (Class<?> clazz : this.interfaceTypes) {
            if (clazz.isInstance(var1_2)) continue;
            var2_3.appendText("item does not implement ").appendText(clazz.getName());
            return;
        }
    }
}

