/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.WindowManager;
import androidx.test.espresso.Root-IA;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;

public final class Root {
    private final View decorView;
    private final EspressoOptional<WindowManager.LayoutParams> windowLayoutParams;

    public View getDecorView() {
        return this.decorView;
    }

    public EspressoOptional<WindowManager.LayoutParams> getWindowLayoutParams() {
        return this.windowLayoutParams;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("application-window-token", this.decorView.getApplicationWindowToken()).add("window-token", this.decorView.getWindowToken()).add("has-window-focus", this.decorView.hasWindowFocus());
        if (this.windowLayoutParams.isPresent()) {
            toStringHelper.add("layout-params-type", this.windowLayoutParams.get().type).add("layout-params-string", this.windowLayoutParams.get());
        }
        toStringHelper.add("decor-view-string", HumanReadables.describe(this.decorView));
        return toStringHelper.toString();
    }

    /*
     * WARNING - void declaration
     */
    private Root(Builder builder) {
        void var1_1;
        this.decorView = (View)Preconditions.checkNotNull(((Builder)var1_1).decorView);
        this.windowLayoutParams = EspressoOptional.fromNullable(((Builder)var1_1).windowLayoutParams);
    }

    /* synthetic */ Root(Builder builder, Root-IA root-IA) {
        this(builder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReady() {
        if (this.decorView.isLayoutRequested()) return false;
        int n = this.windowLayoutParams.get().flags;
        if (this.decorView.hasWindowFocus()) return true;
        if ((n & 8) != 8) return false;
        return true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private View decorView;
        private WindowManager.LayoutParams windowLayoutParams;

        /*
         * WARNING - void declaration
         */
        public Builder withDecorView(View view) {
            void var1_1;
            this.decorView = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withWindowLayoutParams(WindowManager.LayoutParams windowLayoutParams) {
            void var1_1;
            this.windowLayoutParams = var1_1;
            return this;
        }

        public Root build() {
            Root root = new Root(this, null);
            return root;
        }
    }
}

