/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.view.KeyEvent;
import androidx.test.espresso.action.EspressoKey-IA;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import java.util.Locale;

public final class EspressoKey {
    @RemoteMsgField(order=0)
    private final int keyCode;
    @RemoteMsgField(order=1)
    private final int metaState;

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getMetaState() {
        return this.metaState;
    }

    public String toString() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.keyCode, this.metaState};
        return String.format(locale, "keyCode: %s, metaState: %s", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private EspressoKey(Builder builder) {
        this(((Builder)var1_1).builderKeyCode, ((Builder)var1_1).getMetaState());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @RemoteMsgConstructor
    EspressoKey(int keyCode, int metaState) {
        void var2_2;
        void var1_1;
        this.keyCode = var1_1;
        this.metaState = var2_2;
    }

    /* synthetic */ EspressoKey(Builder builder, EspressoKey-IA espressoKey-IA) {
        this(builder);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private int builderKeyCode = -1;
        private boolean isShiftPressed;
        private boolean isAltPressed;
        private boolean isCtrlPressed;

        /*
         * Enabled aggressive block sorting
         */
        private int getMetaState() {
            int n = this.isShiftPressed ? 1 : 0;
            if (this.isAltPressed) {
                n |= 2;
            }
            if (this.isCtrlPressed && Build.VERSION.SDK_INT >= 11) {
                return n | 0x1000;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAltPressed(boolean altPressed) {
            void var1_1;
            this.isAltPressed = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withCtrlPressed(boolean ctrlPressed) {
            void var1_1;
            this.isCtrlPressed = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withKeyCode(int keyCode) {
            void var1_1;
            this.builderKeyCode = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withShiftPressed(boolean shiftPressed) {
            void var1_1;
            this.isShiftPressed = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public EspressoKey build() {
            boolean bl = this.builderKeyCode > 0 && this.builderKeyCode < KeyEvent.getMaxKeyCode();
            Preconditions.checkState(bl, "Invalid key code: %s", this.builderKeyCode);
            return new EspressoKey(this, null);
        }
    }
}

