/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class GeneralClickAction
implements ViewAction {
    private static final String TAG = "GeneralClickAction";
    final CoordinatesProvider coordinatesProvider;
    final Tapper tapper;
    final PrecisionDescriber precisionDescriber;
    private final Optional<ViewAction> rollbackAction;
    private final int inputDevice;
    private final int buttonState;
    private Tapper.Status status;

    @Override
    public String getDescription() {
        Object this_ = ((GeneralClickAction)this_).tapper;
        this_ = this_.toString();
        this_ = ((String)this_).toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append((String)this_).append(" click").toString();
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher<View> matcher = ViewMatchers.isDisplayingAtLeast(90);
        if (this.rollbackAction.isPresent()) {
            return Matchers.allOf(matcher, ((ViewAction)this.rollbackAction.get()).getConstraints());
        }
        return matcher;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber) {
        this((Tapper)var1_1, (CoordinatesProvider)var2_2, (PrecisionDescriber)var3_3, 0, 0, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, ViewAction rollbackAction) {
        this((Tapper)var1_1, (CoordinatesProvider)var2_2, (PrecisionDescriber)var3_3, 0, 0, (ViewAction)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int inputDevice, int buttonState) {
        this((Tapper)var1_1, (CoordinatesProvider)var2_2, (PrecisionDescriber)var3_3, (int)var4_4, (int)var5_5, null);
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int inputDevice, int buttonState, ViewAction rollbackAction) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        this.coordinatesProvider = var2_2;
        this.tapper = var1_1;
        this.precisionDescriber = var3_3;
        this.inputDevice = var4_4;
        this.buttonState = var5_5;
        this.rollbackAction = Optional.fromNullable(var6_6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController uiController, View view) {
        PerformException.Builder builder;
        int n;
        Object object;
        float[] fArray = this.coordinatesProvider.calculateCoordinates((View)object);
        float[] fArray2 = this.precisionDescriber.describePrecision();
        Object object2 = Tapper.Status.FAILURE;
        for (n = 0; object2 != Tapper.Status.SUCCESS && n < 3; ++n) {
            int n2;
            try {
                object2 = this.tapper.sendTap((UiController)((Object)builder), fArray, fArray2, this.inputDevice, this.buttonState);
                n2 = Log.isLoggable((String)TAG, (int)3);
                if (n2 != 0) {
                    String string = TAG;
                    Object object3 = Locale.ROOT;
                    CharSequence charSequence = "%s - At Coordinates: %d, %d and precision: %d, %d";
                    Object[] objectArray = new Object[]{this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1]};
                    object3 = String.format((Locale)object3, (String)charSequence, objectArray);
                    charSequence = new StringBuilder();
                    Log.d((String)string, (String)((StringBuilder)charSequence).append("perform: ").append((String)object3).toString());
                }
            }
            catch (RuntimeException runtimeException) {
                object2 = new PerformException.Builder();
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1]};
                throw ((PerformException.Builder)object2).withActionDescription(String.format(locale, "%s - At Coordinates: %d, %d and precision: %d, %d", objectArray)).withViewDescription(HumanReadables.describe((View)object)).withCause(runtimeException).build();
            }
            n2 = ViewConfiguration.getPressedStateDuration();
            if (n2 > 0) {
                builder.loopMainThreadForAtLeast(n2);
            }
            if (object2 != Tapper.Status.WARNING) continue;
            if (!this.rollbackAction.isPresent()) break;
            ((ViewAction)this.rollbackAction.get()).perform((UiController)((Object)builder), (View)object);
        }
        if (object2 == Tapper.Status.FAILURE) {
            builder = new PerformException.Builder();
            object2 = this.getDescription();
            builder = builder.withActionDescription((String)object2);
            object = HumanReadables.describe((View)object);
            builder = builder.withViewDescription((String)object);
            object2 = Locale.ROOT;
            Object[] objectArray = new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), this.tapper, this.coordinatesProvider, this.precisionDescriber, n, this.rollbackAction.isPresent()};
            object = new RuntimeException(String.format((Locale)object2, "Couldn't click at: %s,%s precision: %s, %s . Tapper: %s coordinate provider: %s precision describer: %s. Tried %s times. With Rollback? %s", objectArray));
            throw builder.withCause((Throwable)object).build();
        }
        if (this.tapper == Tap.SINGLE && object instanceof WebView) {
            builder.loopMainThreadForAtLeast(ViewConfiguration.getDoubleTapTimeout());
            return;
        }
    }
}

