/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Locale;

public final class MotionEvents {
    private static final String TAG = MotionEvents.class.getSimpleName();
    static final int MAX_CLICK_ATTEMPTS = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int mapInputDeviceToToolType(int inputDevice) {
        switch (inputDevice) {
            default: {
                return 0;
            }
            case 16386: {
                return 2;
            }
            case 8194: {
                return 3;
            }
            case 4098: 
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent obtain(MotionEvent downEvent, long eventTime, int action, float[] coordinates) {
        MotionEvent motionEvent;
        void var4_3;
        void var3_2;
        void var1_1;
        return MotionEvents.obtain(downEvent.getDownTime(), (long)var1_1, (int)var3_2, (float[])var4_3, motionEvent.getXPrecision(), motionEvent.getYPrecision(), motionEvent.getSource(), motionEvent.getToolType(0), motionEvent.getButtonState());
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent obtain(long downTime, long eventTime, int action, float[] coordinates, float xPrecision, float yPrecision, int source, int buttonState) {
        void var9_7;
        void var8_6;
        void var7_5;
        void var6_4;
        void var5_3;
        void var4_2;
        void var2_1;
        return MotionEvents.obtain(downTime, (long)var2_1, (int)var4_2, (float[])var5_3, (float)var6_4, (float)var7_5, (int)var8_6, MotionEvents.mapInputDeviceToToolType((int)var8_6), (int)var9_7);
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent obtain(long downTime, long eventTime, int action, float[] coordinates, float xPrecision, float yPrecision, int source, int toolType, int buttonState) {
        void var8_6;
        void var7_5;
        void var6_4;
        void var10_9;
        void var4_2;
        void var2_1;
        long l;
        void var5_3;
        void var9_7;
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[]{pointerCoords};
        MotionEvent.PointerProperties[] pointerPropertiesArray = MotionEvents.getPointerProperties((int)var9_7);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = var5_3[0];
        pointerCoordsArray[0].y = var5_3[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)l, (long)var2_1, (int)var4_2, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)var10_9, (float)var6_4, (float)var7_5, (int)0, (int)0, (int)var8_6, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision) {
        void var1_1;
        return MotionEvents.obtainDownEvent(coordinates, (float[])var1_1, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        void var3_3;
        void var2_2;
        float[] fArray;
        void var1_1;
        Preconditions.checkNotNull(coordinates);
        Preconditions.checkNotNull(var1_1);
        long l = SystemClock.uptimeMillis();
        return MotionEvents.obtain(l, l, 0, fArray, (float)var1_1[0], (float)var1_1[1], (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static MotionEvent obtainMovement(long downTime, float[] coordinates) {
        void var2_1;
        return MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)2, (float)var2_1[0], (float)var2_1[1], (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainMovement(MotionEvent downEvent, float[] coordinates) {
        void var1_1;
        return MotionEvents.obtainMovement(downEvent, SystemClock.uptimeMillis(), (float[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static MotionEvent obtainMovement(long downTime, long eventTime, float[] coordinates) {
        void var4_1;
        void var2_2;
        return MotionEvent.obtain((long)downTime, (long)var2_2, (int)2, (float)var4_1[1], (float)var4_1[1], (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainMovement(MotionEvent downEvent, long eventTime, float[] coordinates) {
        void var1_1;
        MotionEvent motionEvent;
        void var3_2;
        Preconditions.checkNotNull(downEvent);
        Preconditions.checkNotNull(var3_2);
        return MotionEvents.obtain(motionEvent, (long)var1_1, 2, (float[])var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainUpEvent(MotionEvent downEvent, float[] coordinates) {
        void var1_1;
        return MotionEvents.obtainUpEvent(downEvent, SystemClock.uptimeMillis(), (float[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainUpEvent(MotionEvent downEvent, long eventTime, float[] coordinates) {
        void var1_1;
        MotionEvent motionEvent;
        void var3_2;
        Preconditions.checkNotNull(downEvent);
        Preconditions.checkNotNull(var3_2);
        return MotionEvents.obtain(motionEvent, (long)var1_1, 1, (float[])var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision) {
        void var2_2;
        void var1_1;
        return MotionEvents.sendDown(uiController, (float[])var1_1, (float[])var2_2, 0, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(var1_2);
        Preconditions.checkNotNull(var2_3);
        var5_6 = 0;
        block5: while (true) {
            if (var5_6 >= 3) {
                var0 = new PerformException.Builder();
                var1_2 = Locale.ROOT;
                var2_3 = new Object[]{3};
                throw var0.withActionDescription(String.format((Locale)var1_2, "click (after %s attempts)", var2_3)).withViewDescription("unknown").build();
            }
            try {
                var7_8 = MotionEvents.obtainDownEvent((float[])var1_2, (float[])var2_3, (int)var3_4, (int)var4_5);
                var8_9 = var7_8.getDownTime();
                var6_7 = ViewConfiguration.getTapTimeout() / 2;
                var10_10 = var8_9 + (long)var6_7;
                var12_11 = var0.injectMotionEvent(var7_8);
lbl20:
                // 2 sources

                while (true) {
                    var13_12 = SystemClock.uptimeMillis();
                    var15_13 = var10_10 - var13_12;
                    if (var15_13 > 10L) break block5;
                    break;
                }
            }
            catch (InjectEventSecurityException var0_1) {
                var1_2 = new PerformException.Builder();
                throw var1_2.withActionDescription("Send down motion event").withViewDescription("unknown").withCause((Throwable)var0_1).build();
            }
            {
                var13_12 = SystemClock.uptimeMillis();
                var6_7 = ViewConfiguration.getLongPressTimeout();
                if (var13_12 > var8_9 + (long)var6_7) {
                    Log.w((String)MotionEvents.TAG, (String)"Overslept and turned a tap into a long press");
                    var6_7 = true;
                } else {
                    var6_7 = false;
                }
                if (var12_11 != false) return new DownResultHolder(var7_8, var6_7);
                var7_8.recycle();
                ++var5_6;
                continue;
            }
            break;
        }
        {
            var0.loopMainThreadForAtLeast(var15_13 / 4L);
            ** continue;
        }
    }

    private MotionEvents() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void sendCancel(UiController uiController, MotionEvent downEvent) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                var2_11 /* !! */  = new float[]{var1_10.getX(), var1_10.getY()};
                var2_11 /* !! */  = (float[])MotionEvents.obtain((MotionEvent)var1_10, SystemClock.uptimeMillis(), 3, var2_11 /* !! */ );
                var0_1 = var0.injectMotionEvent((MotionEvent)var2_11 /* !! */ );
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of cancel event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 /* !! */  == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_11 /* !! */ ;
                    ** GOTO lbl37
                }
                var2_11 /* !! */ .recycle();
                return;
            }
            return;
        }
        if (var2_11 /* !! */  != null) {
            var2_11 /* !! */ .recycle();
            return;
        }
        return;
        catch (InjectEventSecurityException var0_3) {
            var2_11 /* !! */  = null;
lbl29:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10};
                throw var3_13.withActionDescription(String.format(var4_15, "inject cancel event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl37:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_11 /* !! */ ;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sendMovement(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                Preconditions.checkNotNull(var2_11);
                var2_11 = MotionEvents.obtainMovement(var1_10, (float[])var2_11);
                var0_1 = var0.injectMotionEvent(var2_11);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of motion event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_11;
                    ** GOTO lbl36
                }
                var2_11.recycle();
            }
            return false;
        }
        if (var2_11 != null) {
            var2_11.recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10};
                throw var3_13.withActionDescription(String.format(var4_15, "inject motion event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_11;
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sendUp(UiController uiController, MotionEvent downEvent) {
        UiController uiController2;
        void var1_1;
        float[] fArray = new float[]{var1_1.getX(), var1_1.getY()};
        return MotionEvents.sendUp(uiController2, (MotionEvent)var1_1, fArray);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sendUp(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                Preconditions.checkNotNull(var2_11);
                var2_11 = MotionEvents.obtainUpEvent(var1_10, (float[])var2_11);
                var0_1 = var0.injectMotionEvent(var2_11);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of up event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_11;
                    ** GOTO lbl36
                }
                var2_11.recycle();
            }
            return false;
        }
        if (var2_11 != null) {
            var2_11.recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10};
                throw var3_13.withActionDescription(String.format(var4_15, "inject up event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_11;
                ** continue;
            }
        }
    }

    private static MotionEvent.PointerProperties[] getPointerProperties(int toolType) {
        int n;
        MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[]{pointerProperties};
        pointerPropertiesArray[0].clear();
        pointerPropertiesArray[0].id = 0;
        pointerPropertiesArray[0].toolType = n;
        return pointerPropertiesArray;
    }

    public static class DownResultHolder {
        public final MotionEvent down;
        public final boolean longPress;

        /*
         * WARNING - void declaration
         */
        DownResultHolder(MotionEvent down, boolean longPress) {
            void var2_2;
            void var1_1;
            this.down = var1_1;
            this.longPress = var2_2;
        }
    }
}

