/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.text.Spanned;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class OpenLinkAction
implements ViewAction {
    private final Matcher<String> linkTextMatcher;
    private final Matcher<Uri> uriMatcher;

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.linkTextMatcher, this.uriMatcher};
        return String.format(locale, "open link with text %s and uri %s", objectArray);
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.hasLinks());
    }

    /*
     * WARNING - void declaration
     */
    public OpenLinkAction(Matcher<String> linkTextMatcher, Matcher<Uri> uriMatcher) {
        void var2_2;
        void var1_1;
        this.linkTextMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
        this.uriMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void perform(UiController uiController, View view) {
        uiController = (TextView)view;
        Object[] objectArray = uiController.getText().toString();
        URLSpan[] uRLSpanArray = uiController.getUrls();
        Spanned spanned = (Spanned)uiController.getText();
        ArrayList arrayList = Lists.newArrayList();
        int n = uRLSpanArray.length;
        int n2 = 0;
        while (true) {
            Object object;
            Object object2;
            if (n2 >= n) {
                PerformException.Builder builder = new PerformException.Builder();
                object2 = this.getDescription();
                builder = builder.withActionDescription((String)object2);
                object = HumanReadables.describe((View)object);
                builder = builder.withViewDescription((String)object);
                object2 = Locale.ROOT;
                objectArray = new Object[]{this.linkTextMatcher, this.uriMatcher, arrayList, Arrays.asList(uRLSpanArray)};
                object = new RuntimeException(String.format((Locale)object2, "Link with text '%s' and uri '%s' not found. List of links found in this view: %s\nList of uris: %s", objectArray));
                throw builder.withCause((Throwable)object).build();
            }
            URLSpan uRLSpan = uRLSpanArray[n2];
            int n3 = spanned.getSpanStart((Object)uRLSpan);
            boolean bl = n3 != -1;
            String string = String.valueOf(uRLSpan);
            StringBuilder stringBuilder = new StringBuilder();
            Preconditions.checkState(bl, stringBuilder.append("Unable to get start of text associated with url: ").append(string).toString());
            int n4 = spanned.getSpanEnd((Object)uRLSpan);
            bl = n4 != -1;
            String string2 = String.valueOf(uRLSpan);
            StringBuilder stringBuilder2 = new StringBuilder();
            Preconditions.checkState(bl, stringBuilder2.append("Unable to get end of text associated with url: ").append(string2).toString());
            object2 = objectArray.substring(n3, n4);
            arrayList.add(object2);
            if (this.linkTextMatcher.matches(object2) && this.uriMatcher.matches((Object)Uri.parse((String)uRLSpan.getURL()))) {
                uRLSpan.onClick((View)object);
                return;
            }
            ++n2;
        }
    }
}

