/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class RepeatActionUntilViewState
implements ViewAction {
    private final ViewAction mAction;
    private final Matcher<View> mDesiredStateMatcher;
    private final int mMaxAttempts;

    @Override
    public String getDescription() {
        StringDescription stringDescription = new StringDescription();
        this.mDesiredStateMatcher.describeTo((Description)stringDescription);
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.mAction.getDescription(), stringDescription};
        return String.format(locale, "%s until: %s", objectArray);
    }

    @Override
    public Matcher<View> getConstraints() {
        return this.mAction.getConstraints();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected RepeatActionUntilViewState(ViewAction action, Matcher<View> desiredStateMatcher, int maxAttempts) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(var1_1);
        Preconditions.checkNotNull(var2_2);
        boolean bl = var3_3 > true;
        Preconditions.checkState(bl, "maxAttempts should be greater than 1");
        this.mAction = var1_1;
        this.mDesiredStateMatcher = var2_2;
        this.mMaxAttempts = var3_3;
    }

    @Override
    public void perform(UiController uiController, View view) {
        PerformException.Builder builder;
        Object object;
        int n;
        for (n = 1; !this.mDesiredStateMatcher.matches(object) && n <= this.mMaxAttempts; ++n) {
            this.mAction.perform((UiController)((Object)builder), (View)object);
            builder.loopMainThreadUntilIdle();
        }
        if (n > this.mMaxAttempts) {
            builder = new PerformException.Builder();
            Object object2 = this.getDescription();
            builder = builder.withActionDescription((String)object2);
            object = HumanReadables.describe((View)object);
            builder = builder.withViewDescription((String)object);
            object2 = Locale.ROOT;
            Object[] objectArray = new Object[]{this.mMaxAttempts};
            object = new RuntimeException(String.format((Locale)object2, "Failed to achieve view state after %d attempts", objectArray));
            throw builder.withCause((Throwable)object).build();
        }
    }
}

