/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import androidx.test.espresso.base.AsyncTaskPoolMonitor$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.base.AsyncTaskPoolMonitor$IdleMonitor$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.base.AsyncTaskPoolMonitor$IdleMonitor$1$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class AsyncTaskPoolMonitor {
    private final AtomicReference<IdleMonitor> monitor;
    private final ThreadPoolExecutor pool;
    private final AtomicInteger activeBarrierChecks;

    IdleNotifier<Runnable> asIdleNotifier() {
        IdleNotifier<Runnable> idleNotifier = new IdleNotifier<Runnable>(this){
            final /* synthetic */ AsyncTaskPoolMonitor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void cancelCallback() {
                this.this$0.cancelIdleMonitor();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void registerNotificationCallback(Runnable r) {
                void var1_1;
                this.this$0.notifyWhenIdle((Runnable)var1_1);
            }

            @Override
            public boolean isIdleNow() {
                return this.this$0.isIdleNow();
            }
        };
        return idleNotifier;
    }

    /*
     * WARNING - void declaration
     */
    AsyncTaskPoolMonitor(ThreadPoolExecutor pool) {
        void var1_1;
        Serializable serializable = new Serializable(null);
        this.monitor = serializable;
        super(0);
        this.activeBarrierChecks = serializable;
        this.pool = (ThreadPoolExecutor)Preconditions.checkNotNull(var1_1);
    }

    void cancelIdleMonitor() {
        IdleMonitor this_ = ((AsyncTaskPoolMonitor)((Object)this_)).monitor.getAndSet(null);
        if (this_ != null) {
            this_.poison();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void notifyWhenIdle(Runnable idleCallback) {
        void var1_1;
        Preconditions.checkNotNull(idleCallback);
        IdleMonitor idleMonitor = new IdleMonitor((Runnable)var1_1);
        Preconditions.checkState(AsyncTaskPoolMonitor$$ExternalSyntheticBackportWithForwarding0.m(this.monitor, null, idleMonitor), "cannot monitor for idle recursively!");
        idleMonitor.monitorForIdle();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isIdleNow() {
        if (!this.pool.getQueue().isEmpty()) {
            return false;
        }
        int n = this.pool.getActiveCount();
        int n2 = n != 0 ? (this.monitor.get() == null ? n - this.activeBarrierChecks.get() : n) : n;
        if (n2 != 0) return 0 != 0;
        return 1 != 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IdleMonitor {
        private final Runnable onIdle;
        private final AtomicInteger barrierGeneration;
        private final CyclicBarrier barrier;
        private volatile boolean poisoned;

        /*
         * WARNING - void declaration
         */
        private IdleMonitor(Runnable onIdle) {
            void var2_2;
            Object object = new AtomicInteger(0);
            this.barrierGeneration = object;
            this.onIdle = (Runnable)Preconditions.checkNotNull(var2_2);
            ThreadPoolExecutor threadPoolExecutor = AsyncTaskPoolMonitor.this.pool;
            int n = threadPoolExecutor.getCorePoolSize();
            Runnable runnable = new Runnable(){
                final /* synthetic */ AsyncTaskPoolMonitor val$this$0;
                final /* synthetic */ Runnable val$onIdle;
                final /* synthetic */ IdleMonitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$this$0 = asyncTaskPoolMonitor;
                    this.val$onIdle = runnable;
                }

                @Override
                public void run() {
                    if (this.this$1.AsyncTaskPoolMonitor.this.pool.getQueue().isEmpty()) {
                        AsyncTaskPoolMonitor$IdleMonitor$1$$ExternalSyntheticBackportWithForwarding0.m(this.this$1.AsyncTaskPoolMonitor.this.monitor, this.this$1, null);
                        this.val$onIdle.run();
                        return;
                    }
                    this.this$1.monitorForIdle();
                }
            };
            this.barrier = object = new CyclicBarrier(n, runnable);
        }

        private void monitorForIdle() {
            if (this.poisoned) {
                return;
            }
            if (AsyncTaskPoolMonitor.this.isIdleNow()) {
                AsyncTaskPoolMonitor$IdleMonitor$$ExternalSyntheticBackportWithForwarding0.m(AsyncTaskPoolMonitor.this.monitor, this, null);
                this.onIdle.run();
                return;
            }
            int n = AsyncTaskPoolMonitor.this.pool.getCorePoolSize();
            BarrierRestarter barrierRestarter = new BarrierRestarter(this.barrier, this.barrierGeneration);
            for (int i = 0; i < n; ++i) {
                Object object = AsyncTaskPoolMonitor.this;
                object = ((AsyncTaskPoolMonitor)object).pool;
                Runnable runnable = new Runnable(){
                    final /* synthetic */ BarrierRestarter val$restarter;
                    final /* synthetic */ IdleMonitor this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$restarter = barrierRestarter;
                    }

                    /*
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        while (!this.this$1.poisoned) {
                            this.this$1.AsyncTaskPoolMonitor.this.activeBarrierChecks.incrementAndGet();
                            int n = this.this$1.barrierGeneration.get();
                            try {
                                this.this$1.barrier.await();
                                this.this$1.AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                return;
                            }
                            catch (InterruptedException interruptedException) {
                                this.val$restarter.restart(n);
                                continue;
                                catch (BrokenBarrierException brokenBarrierException) {
                                    this.val$restarter.restart(n);
                                }
                                finally {
                                    this.this$1.AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                    continue;
                                }
                            }
                            this.this$1.AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                        }
                    }
                };
                ((ThreadPoolExecutor)object).execute(runnable);
            }
        }

        private void poison() {
            this.poisoned = true;
            this.barrier.reset();
        }
    }

    private static class BarrierRestarter {
        private final CyclicBarrier barrier;
        private final AtomicInteger barrierGeneration;

        /*
         * WARNING - void declaration
         */
        BarrierRestarter(CyclicBarrier barrier, AtomicInteger barrierGeneration) {
            void var2_2;
            void var1_1;
            this.barrier = var1_1;
            this.barrierGeneration = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        synchronized void restart(int fromGeneration) {
            void var1_1;
            if (this.barrierGeneration.compareAndSet((int)var1_1, (int)(var1_1 + true))) {
                this.barrier.reset();
                return;
            }
        }
    }
}

