/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import androidx.test.core.app.DeviceCapture;
import androidx.test.core.graphics.BitmapStorage;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.base.AssertionErrorHandler;
import androidx.test.espresso.base.DefaultFailureHandler$$ExternalSyntheticLambda0;
import androidx.test.espresso.base.DefaultFailureHandler$$ExternalSyntheticLambda1;
import androidx.test.espresso.base.EspressoExceptionHandler;
import androidx.test.espresso.base.PerformExceptionHandler;
import androidx.test.espresso.base.ThrowableHandler;
import androidx.test.espresso.base.ViewHierarchyExceptionHandler;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

public final class DefaultFailureHandler
implements FailureHandler {
    private static final AtomicInteger failureCount;
    private final List<FailureHandler> handlers;
    private final PlatformTestStorage testStorage;

    static ViewHierarchyExceptionHandler.Truncater<AmbiguousViewMatcherException> getAmbiguousViewMatcherExceptionTruncater() {
        return DefaultFailureHandler$$ExternalSyntheticLambda0.INSTANCE;
    }

    static ViewHierarchyExceptionHandler.Truncater<NoMatchingViewException> getNoMatchingViewExceptionTruncater() {
        return DefaultFailureHandler$$ExternalSyntheticLambda1.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Throwable lambda$getAmbiguousViewMatcherExceptionTruncater$1(AmbiguousViewMatcherException exception, int msgLen, String viewHierarchyFile) {
        void var2_2;
        void var1_1;
        AmbiguousViewMatcherException ambiguousViewMatcherException;
        AmbiguousViewMatcherException.Builder builder = new AmbiguousViewMatcherException.Builder();
        return builder.from(ambiguousViewMatcherException).withMaxMsgLen((int)var1_1).withViewHierarchyFile((String)var2_2).build();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Throwable lambda$getNoMatchingViewExceptionTruncater$0(NoMatchingViewException exception, int msgLen, String viewHierarchyFile) {
        void var2_2;
        void var1_1;
        NoMatchingViewException noMatchingViewException;
        NoMatchingViewException.Builder builder = new NoMatchingViewException.Builder();
        return builder.from(noMatchingViewException).withMaxMsgLen((int)var1_1).withViewHierarchyFile((String)var2_2).build();
    }

    static {
        AtomicInteger atomicInteger;
        failureCount = atomicInteger = new AtomicInteger(0);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFailureHandler(@TargetContext Context appContext) {
        this((Context)var1_1, PlatformTestStorageRegistry.getInstance());
        void var1_1;
    }

    DefaultFailureHandler(@TargetContext Context appContext, PlatformTestStorage testStorage) {
        Object object;
        Object object2;
        Class[] classArray = new ArrayList();
        ((DefaultFailureHandler)((Object)this_)).handlers = classArray;
        ((DefaultFailureHandler)((Object)this_)).testStorage = object2;
        classArray = ((DefaultFailureHandler)((Object)this_)).handlers;
        ViewHierarchyExceptionHandler<AmbiguousViewMatcherException> viewHierarchyExceptionHandler = new ViewHierarchyExceptionHandler<AmbiguousViewMatcherException>((PlatformTestStorage)object2, failureCount, NoMatchingViewException.class, DefaultFailureHandler.getNoMatchingViewExceptionTruncater());
        classArray.add(viewHierarchyExceptionHandler);
        classArray = ((DefaultFailureHandler)((Object)this_)).handlers;
        viewHierarchyExceptionHandler = new ViewHierarchyExceptionHandler<AmbiguousViewMatcherException>((PlatformTestStorage)object2, failureCount, AmbiguousViewMatcherException.class, DefaultFailureHandler.getAmbiguousViewMatcherExceptionTruncater());
        classArray.add(viewHierarchyExceptionHandler);
        object2 = ((DefaultFailureHandler)((Object)this_)).handlers;
        classArray = new PerformExceptionHandler((Context)Preconditions.checkNotNull(object), PerformException.class);
        object2.add((FailureHandler)classArray);
        object = ((DefaultFailureHandler)((Object)this_)).handlers;
        classArray = new Class[]{AssertionFailedError.class, AssertionError.class};
        object2 = new AssertionErrorHandler(classArray);
        object.add((FailureHandler)object2);
        object = ((DefaultFailureHandler)((Object)this_)).handlers;
        object2 = new EspressoExceptionHandler(EspressoException.class);
        object.add((FailureHandler)object2);
        List<FailureHandler> this_ = ((DefaultFailureHandler)((Object)this_)).handlers;
        object = new ThrowableHandler();
        this_.add((FailureHandler)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(Throwable error, Matcher<View> viewMatcher) {
        int n = failureCount.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder();
        TestOutputEmitter.captureWindowHierarchy((String)stringBuilder.append("explore-window-hierarchy-").append(n).append(".xml").toString());
        stringBuilder = new StringBuilder();
        ((DefaultFailureHandler)((Object)iterator)).takeScreenshot(stringBuilder.append("view-op-error-").append(n).toString());
        Iterator<FailureHandler> iterator = ((DefaultFailureHandler)((Object)iterator)).handlers.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var1_1;
            ((FailureHandler)iterator.next()).handle((Throwable)var1_1, (Matcher<View>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void takeScreenshot(String outputName) {
        try {
            void var1_2;
            boolean bl = DeviceCapture.canTakeScreenshot();
            if (bl) {
                BitmapStorage.writeToTestStorage((Bitmap)DeviceCapture.takeScreenshotNoSync(), (PlatformTestStorage)((DefaultFailureHandler)object).testStorage, (String)var1_2);
                return;
            }
            Object object = new StringBuilder();
            object = ((StringBuilder)object).append((String)var1_2).append(".png").toString();
            TestOutputEmitter.takeScreenshot((String)object);
            return;
        }
        catch (IOException | Error | RuntimeException throwable) {
            Log.w((String)"DefaultFailureHandler", (String)"Failed to take screenshot", (Throwable)throwable);
            return;
        }
    }

    static abstract class TypedFailureHandler<T>
    implements FailureHandler {
        private final List<Class<?>> acceptedTypes;

        /*
         * WARNING - void declaration
         */
        public TypedFailureHandler(Class<?> ... acceptedTypes) {
            void var1_1;
            this.acceptedTypes = (List)Preconditions.checkNotNull(Arrays.asList(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handle(Throwable error, Matcher<View> viewMatcher) {
            if (error != null) {
                Iterator<Class<?>> iterator = this.acceptedTypes.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    void var1_1;
                    if (!iterator.next().isInstance(var1_1)) continue;
                    this.handleSafely(var1_1, (Matcher<View>)var2_2);
                    return;
                }
            }
        }

        abstract void handleSafely(T var1, Matcher<View> var2);
    }
}

