/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.Interrogator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class LooperIdlingResourceInterrogationHandler
implements Interrogator.InterrogationHandler<Void>,
IdlingResource {
    private static final ConcurrentHashMap<String, LooperIdlingResourceInterrogationHandler> insts;
    private final Interrogator.QueueInterrogationHandler<Boolean> queueHasNewTasks;
    private final String name;
    private volatile boolean started;
    private volatile MessageQueue queue;
    private volatile boolean idle;
    private volatile IdlingResource.ResourceCallback cb;

    static LooperIdlingResourceInterrogationHandler forLooper(Looper l) {
        Object object;
        Object object2 = Locale.ROOT;
        Object object3 = new Object[]{object.getThread().getId(), object.getThread().getName()};
        object2 = String.format((Locale)object2, "LooperIdlingResource-%s-%s", object3);
        object3 = new LooperIdlingResourceInterrogationHandler((String)object2);
        if ((object2 = insts.putIfAbsent((String)object2, (LooperIdlingResourceInterrogationHandler)object3)) != null) {
            return object2;
        }
        object2 = new Handler(object);
        object = new Runnable(){

            @Override
            public void run() {
                LooperIdlingResourceInterrogationHandler.this.queue = Looper.myQueue();
                LooperIdlingResourceInterrogationHandler.this.started = true;
                Interrogator.loopAndInterrogate(LooperIdlingResourceInterrogationHandler.this);
            }
        };
        object2.post((Runnable)object);
        return object3;
    }

    @Override
    public String getMessage() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Void get() {
        return null;
    }

    static {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        insts = concurrentHashMap;
    }

    /*
     * WARNING - void declaration
     */
    private LooperIdlingResourceInterrogationHandler(String name) {
        void var1_1;
        Interrogator.QueueInterrogationHandler<Boolean> queueInterrogationHandler;
        this.queueHasNewTasks = queueInterrogationHandler = new Interrogator.QueueInterrogationHandler<Boolean>(this){
            private Boolean hasTasks = Boolean.FALSE;

            @Override
            public Boolean get() {
                return this.hasTasks;
            }

            @Override
            public boolean barrierUp() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }

            @Override
            public boolean queueEmpty() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueLong() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueSoon() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }
        };
        this.started = false;
        this.queue = null;
        this.idle = true;
        this.cb = null;
        this.name = var1_1;
    }

    @Override
    public void quitting() {
        this.transitionToIdle();
    }

    /*
     * WARNING - void declaration
     */
    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback cb) {
        void var1_1;
        this.cb = var1_1;
    }

    @Override
    public void setMessage(Message message) {
    }

    private void transitionToIdle() {
        this.idle = true;
        if (this.cb != null) {
            this.cb.onTransitionToIdle();
            return;
        }
    }

    @Override
    public boolean barrierUp() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean beforeTaskDispatch() {
        this.idle = false;
        return true;
    }

    public boolean isIdleNow() {
        if (!this.started) {
            return false;
        }
        if (this.idle) {
            return Boolean.FALSE.equals(Interrogator.peekAtQueueState(this.queue, this.queueHasNewTasks));
        }
        return false;
    }

    @Override
    public boolean queueEmpty() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean taskDueLong() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean taskDueSoon() {
        this.idle = false;
        return true;
    }
}

