/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import androidx.test.espresso.Root;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

final class RootsOracle
implements ActiveRootLister {
    private static final String TAG = RootsOracle.class.getSimpleName();
    private static final String WINDOW_MANAGER_IMPL_CLAZZ = "android.view.WindowManagerImpl";
    private static final String WINDOW_MANAGER_GLOBAL_CLAZZ = "android.view.WindowManagerGlobal";
    private static final String VIEWS_FIELD = "mViews";
    private static final String WINDOW_PARAMS_FIELD = "mParams";
    private static final String GET_DEFAULT_IMPL = "getDefault";
    private static final String GET_GLOBAL_INSTANCE = "getInstance";
    private final Looper mainLooper;
    private boolean initialized;
    private Object windowManagerObj;
    private Field viewsField;
    private Field paramsField;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Root> listActiveRoots() {
        List<WindowManager.LayoutParams> list;
        Preconditions.checkState(((RootsOracle)this_).mainLooper.equals(Looper.myLooper()), "must be called on main thread.");
        if (!((RootsOracle)this_).initialized) {
            ((RootsOracle)this_).initialize();
        }
        if (((RootsOracle)this_).windowManagerObj == null) {
            Log.w((String)TAG, (String)"No reflective access to windowmanager object.");
            return Lists.newArrayList();
        }
        if (((RootsOracle)this_).viewsField == null) {
            Log.w((String)TAG, (String)"No reflective access to mViews");
            return Lists.newArrayList();
        }
        if (((RootsOracle)this_).paramsField == null) {
            Log.w((String)TAG, (String)"No reflective access to mParams");
            return Lists.newArrayList();
        }
        try {
            Object this_;
            List<WindowManager.LayoutParams> list2;
            int n = Build.VERSION.SDK_INT;
            if (n >= 19) {
                list = (List<WindowManager.LayoutParams>)((RootsOracle)this_).viewsField.get(((RootsOracle)this_).windowManagerObj);
                list2 = (List<WindowManager.LayoutParams>)((RootsOracle)this_).paramsField.get(((RootsOracle)this_).windowManagerObj);
                this_ = list;
                list = list2;
            }
            list = Arrays.asList((View[])((RootsOracle)this_).viewsField.get(((RootsOracle)this_).windowManagerObj));
            list2 = Arrays.asList((WindowManager.LayoutParams[])((RootsOracle)this_).paramsField.get(((RootsOracle)this_).windowManagerObj));
            this_ = list;
            list = list2;
        }
        catch (RuntimeException runtimeException) {
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{((RootsOracle)this_).viewsField, ((RootsOracle)this_).paramsField, ((RootsOracle)this_).windowManagerObj};
            Log.w((String)string, (String)String.format(locale, "Reflective access to %s or %s on %s failed.", objectArray), (Throwable)runtimeException);
            return Lists.newArrayList();
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{((RootsOracle)this_).viewsField, ((RootsOracle)this_).paramsField, ((RootsOracle)this_).windowManagerObj};
            Log.w((String)string, (String)String.format(locale, "Reflective access to %s or %s on %s failed.", objectArray), (Throwable)illegalAccessException);
            return Lists.newArrayList();
        }
        ArrayList arrayList = Lists.newArrayList();
        int n = this_.size() + -1;
        while (true) {
            if (n < 0) {
                return arrayList;
            }
            Root.Builder builder = new Root.Builder();
            arrayList.add(builder.withDecorView((View)this_.get(n)).withWindowLayoutParams(list.get(n)).build());
            --n;
        }
    }

    /*
     * WARNING - void declaration
     */
    RootsOracle(Looper mainLooper) {
        void var1_1;
        this.mainLooper = var1_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        this.initialized = true;
        String string = Build.VERSION.SDK_INT > 16 ? WINDOW_MANAGER_GLOBAL_CLAZZ : WINDOW_MANAGER_IMPL_CLAZZ;
        String string2 = Build.VERSION.SDK_INT > 16 ? GET_GLOBAL_INSTANCE : GET_DEFAULT_IMPL;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, new Class[0]);
            this.windowManagerObj = method.invoke(null, new Object[0]);
            this.viewsField = clazz.getDeclaredField(VIEWS_FIELD);
            this.viewsField.setAccessible(true);
            this.paramsField = clazz.getDeclaredField(WINDOW_PARAMS_FIELD);
            this.paramsField.setAccessible(true);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string3 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string2, string};
            Log.e((String)string3, (String)String.format(locale, "could not invoke: %s on %s", objectArray), (Throwable)invocationTargetException.getCause());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string};
            Log.e((String)string2, (String)String.format(locale, "could not find class: %s", objectArray), (Throwable)classNotFoundException);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{WINDOW_PARAMS_FIELD, VIEWS_FIELD, string};
            Log.e((String)string2, (String)String.format(locale, "could not find field: %s or %s on %s", objectArray), (Throwable)noSuchFieldException);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string4 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string2, string};
            Log.e((String)string4, (String)String.format(locale, "could not find method: %s on %s", objectArray), (Throwable)noSuchMethodException);
            return;
        }
        catch (RuntimeException runtimeException) {
            String string5 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string, string2, VIEWS_FIELD};
            Log.e((String)string5, (String)String.format(locale, "reflective setup failed using obj: %s method: %s field: %s", objectArray), (Throwable)runtimeException);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            String string6 = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string, string2, VIEWS_FIELD};
            Log.e((String)string6, (String)String.format(locale, "reflective setup failed using obj: %s method: %s field: %s", objectArray), (Throwable)illegalAccessException);
            return;
        }
    }
}

