/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class WindowManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = WindowManagerEventInjectionStrategy.class.getSimpleName();
    private boolean initComplete;
    private Object wmInstance;
    private Method injectInputKeyEventMethod;
    private Method injectInputMotionEventMethod;

    /*
     * Enabled aggressive block sorting
     */
    WindowManagerEventInjectionStrategy() {
        boolean bl = Build.VERSION.SDK_INT >= 7 && Build.VERSION.SDK_INT <= 15;
        Preconditions.checkState(bl, "Unsupported API level.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize() {
        Object object;
        Object object2;
        Class clazz;
        if (this.initComplete) {
            return;
        }
        try {
            Log.d((String)TAG, (String)"Trying to create injection strategy.");
            clazz = Class.forName("android.os.ServiceManager");
            object2 = "getService";
            object = new Class[]{String.class};
            object2 = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            ((Method)object2).setAccessible(true);
            object = new Object[]{"window"};
            clazz = ((Method)object2).invoke((Object)clazz, (Object[])object);
            object2 = Class.forName("android.view.IWindowManager$Stub");
            object = "asInterface";
            Object[] objectArray = new Class[]{IBinder.class};
            object = ((Class)object2).getDeclaredMethod((String)object, (Class<?>[])objectArray);
            ((Method)object).setAccessible(true);
            objectArray = new Object[]{clazz};
            this.wmInstance = ((Method)object).invoke(object2, objectArray);
            clazz = this.wmInstance.getClass();
            object2 = "injectPointerEvent";
            object = new Class[]{MotionEvent.class, Boolean.TYPE};
            this.injectInputMotionEventMethod = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            this.injectInputMotionEventMethod.setAccessible(true);
            clazz = this.wmInstance.getClass();
            object2 = "injectKeyEvent";
            object = new Class[2];
            object[0] = KeyEvent.class;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = new Class(classNotFoundException);
            throw clazz;
        }
        catch (IllegalAccessException illegalAccessException) {
            clazz = new Class(illegalAccessException);
            throw clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            clazz = new Class(invocationTargetException);
            throw clazz;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = new Class(noSuchMethodException);
            throw clazz;
        }
        {
            object[1] = Boolean.TYPE;
            this.injectInputKeyEventMethod = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            this.injectInputKeyEventMethod.setAccessible(true);
            this.initComplete = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        Object object;
        block5: {
            try {
                Method method = ((WindowManagerEventInjectionStrategy)this_).injectInputKeyEventMethod;
                Object this_ = ((WindowManagerEventInjectionStrategy)this_).wmInstance;
                Object[] objectArray = new Object[]{object, true};
                return (Boolean)method.invoke(this_, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new RuntimeException(illegalAccessException);
                throw object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (SecurityException securityException) {
                object = new InjectEventSecurityException(securityException);
                throw object;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                if (object instanceof SecurityException) break block5;
            }
            object = new RuntimeException(invocationTargetException);
            throw object;
        }
        InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException((Throwable)object);
        throw injectEventSecurityException;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEvent(MotionEvent motionEvent, boolean sync) throws InjectEventSecurityException {
        Object object;
        block5: {
            try {
                void var2_8;
                Method method = ((WindowManagerEventInjectionStrategy)this_).injectInputMotionEventMethod;
                Object this_ = ((WindowManagerEventInjectionStrategy)this_).wmInstance;
                Object[] objectArray = new Object[]{object, (boolean)var2_8};
                return (Boolean)method.invoke(this_, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new RuntimeException(illegalAccessException);
                throw object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (SecurityException securityException) {
                object = new InjectEventSecurityException(securityException);
                throw object;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                if (object instanceof SecurityException) break block5;
            }
            object = new RuntimeException(invocationTargetException);
            throw object;
        }
        InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException((Throwable)object);
        throw injectEventSecurityException;
    }
}

